/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar;

import com.github.maven_nar.AbstractNarMojo;
import com.github.maven_nar.Library;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class NarSystemMojo
extends AbstractNarMojo {
    public final void narExecute() throws MojoExecutionException, MojoFailureException {
        String packageName = null;
        String narSystemName = null;
        File narSystemDirectory = null;
        boolean jniFound = false;
        Iterator<Library> i = this.getLibraries().iterator();
        while (!jniFound && i.hasNext()) {
            Library library = i.next();
            if (!library.getType().equals("jni") && !library.getType().equals("shared")) continue;
            packageName = library.getNarSystemPackage();
            narSystemName = library.getNarSystemName();
            narSystemDirectory = new File(this.getTargetDirectory(), library.getNarSystemDirectory());
            jniFound = true;
        }
        if (!jniFound || packageName == null) {
            if (!jniFound) {
                this.getLog().debug((CharSequence)"NAR: not building a shared or JNI library, so not generating NarSystem class.");
            } else {
                this.getLog().warn((CharSequence)"NAR: no system package specified; unable to generate NarSystem class.");
            }
            return;
        }
        narSystemDirectory.mkdirs();
        this.getMavenProject().addCompileSourceRoot(narSystemDirectory.getPath());
        File fullDir = new File(narSystemDirectory, packageName.replace('.', '/'));
        fullDir.mkdirs();
        File narSystem = new File(fullDir, narSystemName + ".java");
        this.getLog().info((CharSequence)("Generating " + narSystem));
        try {
            String output = this.getOutput(true);
            FileOutputStream fos = new FileOutputStream(narSystem);
            PrintWriter p = new PrintWriter(fos);
            p.println("// DO NOT EDIT: Generated by NarSystemGenerate.");
            p.println("package " + packageName + ";");
            p.println("");
            p.println("/**");
            p.println(" * Generated class to load the correct version of the jni library");
            p.println(" *");
            p.println(" * @author nar-maven-plugin");
            p.println(" */");
            p.println("public final class NarSystem");
            p.println("{");
            p.println("");
            p.println("    private NarSystem() ");
            p.println("    {");
            p.println("    }");
            p.println("");
            p.println("   /**");
            p.println("    * Load jni library: " + output);
            p.println("    *");
            p.println("    * @author nar-maven-plugin");
            p.println("    */");
            p.println("    public static void loadLibrary()");
            p.println("    {");
            p.println("        System.loadLibrary(\"" + output + "\");");
            p.println("    }");
            p.println("");
            p.println("    public static int runUnitTests() {");
            p.println("\t       return new NarSystem().runUnitTestsNative();");
            p.println("}");
            p.println("");
            p.println("    public native int runUnitTestsNative();");
            p.println("}");
            p.close();
            fos.close();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not write '" + narSystemName + "'", (Exception)e);
        }
    }
}

