/*
 * Decompiled with CFR 0.152.
 */
package com.github.maven_nar.cpptasks.borland;

import com.github.maven_nar.cpptasks.CCTask;
import com.github.maven_nar.cpptasks.OptimizationEnum;
import com.github.maven_nar.cpptasks.borland.BorlandLinker;
import com.github.maven_nar.cpptasks.borland.BorlandProcessor;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompiler;
import com.github.maven_nar.cpptasks.compiler.CommandLineCompilerConfiguration;
import com.github.maven_nar.cpptasks.compiler.LinkType;
import com.github.maven_nar.cpptasks.compiler.Linker;
import com.github.maven_nar.cpptasks.compiler.Processor;
import com.github.maven_nar.cpptasks.compiler.ProgressMonitor;
import com.github.maven_nar.cpptasks.parser.CParser;
import com.github.maven_nar.cpptasks.parser.Parser;
import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Environment;

public class BorlandResourceCompiler
extends CommandLineCompiler {
    private static final BorlandResourceCompiler instance = new BorlandResourceCompiler(false, null);

    public static BorlandResourceCompiler getInstance() {
        return instance;
    }

    private BorlandResourceCompiler(boolean newEnvironment, Environment env) {
        super("brc32", "c:\\__bogus\\__bogus.rc", new String[]{".rc"}, new String[]{".h", ".hpp", ".inl"}, ".res", false, null, newEnvironment, env);
    }

    protected void addImpliedArgs(Vector args, boolean debug, boolean multithreaded, boolean exceptions, LinkType linkType, Boolean rtti, OptimizationEnum optimization) {
        args.addElement("-r");
    }

    protected void addWarningSwitch(Vector args, int level) {
    }

    public Processor changeEnvironment(boolean newEnvironment, Environment env) {
        if (newEnvironment || env != null) {
            return new BorlandResourceCompiler(newEnvironment, env);
        }
        return this;
    }

    public void compile(CCTask task, File outputDir, String[] sourceFiles, String[] args, String[] endArgs, boolean relentless, CommandLineCompilerConfiguration config, ProgressMonitor monitor) throws BuildException {
        super.compile(task, outputDir, sourceFiles, args, endArgs, relentless, config, monitor);
    }

    protected Parser createParser(File source) {
        return new CParser();
    }

    protected int getArgumentCountPerInputFile() {
        return 2;
    }

    protected void getDefineSwitch(StringBuffer buffer, String define, String value) {
        buffer.append("-d");
        buffer.append(define);
        if (value != null && value.length() > 0) {
            buffer.append('=');
            buffer.append(value);
        }
    }

    protected File[] getEnvironmentIncludePath() {
        return BorlandProcessor.getEnvironmentPath("brc32", 'i', new String[]{"..\\include"});
    }

    protected String getIncludeDirSwitch(String includeDir) {
        return BorlandProcessor.getIncludeDirSwitch("-i", includeDir);
    }

    protected String getInputFileArgument(File outputDir, String filename, int index) {
        if (index == 0) {
            String[] outputFileNames = this.getOutputFileNames(filename, null);
            String fullOutputName = new File(outputDir, outputFileNames[0]).toString();
            return "-fo" + fullOutputName;
        }
        return filename;
    }

    public Linker getLinker(LinkType type) {
        return BorlandLinker.getInstance().getLinker(type);
    }

    public int getMaximumCommandLength() {
        return 1024;
    }

    protected int getMaximumInputFilesPerCommand() {
        return 1;
    }

    protected int getTotalArgumentLengthForInputFile(File outputDir, String inputFile) {
        String arg1 = this.getInputFileArgument(outputDir, inputFile, 0);
        String arg2 = this.getInputFileArgument(outputDir, inputFile, 1);
        return arg1.length() + arg2.length() + 2;
    }

    protected void getUndefineSwitch(StringBuffer buffer, String define) {
    }
}

