/*
 * Decompiled with CFR 0.152.
 */
package humanize.time;

import com.google.common.base.MoreObjects;
import humanize.time.TimeMillis;

public class Pace {
    private final long value;
    private final String accuracy;
    private final String timeUnit;
    public static final Pace EMPTY = new Pace(0L, Accuracy.NONE, TimeMillis.SECOND);

    public Pace(long value, Accuracy accuracy, TimeMillis timeUnit) {
        this.value = value;
        this.accuracy = accuracy.name().toLowerCase();
        this.timeUnit = timeUnit.key();
    }

    public String getAccuracy() {
        return this.accuracy;
    }

    public String getTimeUnit() {
        return this.timeUnit;
    }

    public long getValue() {
        return this.value;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value).add("accuracy", (Object)this.accuracy).add("timeUnit", (Object)this.timeUnit).toString();
    }

    public static enum Accuracy {
        NONE,
        APROX,
        LESS_THAN;

    }
}

