/**
 * Copyright 2011 The Buzz Media, LLC
 * Copyright 2015 Mickael Jeanroy <mickael.jeanroy@gmail.com>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.thebuzzmedia.exiftool.process;

import java.io.IOException;

/**
 * Command Executor.
 */
public interface CommandExecutor {

	/**
	 * Execute command and build the result.
	 *
	 * **NOTE:** Execution is synchronous.
	 *
	 * @param command Command input.
	 * @return Result of execution.
	 * @throws IOException If an error occurred during execution.
	 */
	CommandResult execute(Command command) throws IOException;

	/**
	 * Execute command and build the result.
	 * **NOTE:** Execution is synchronous.
	 *
	 * @param command Command.
	 * @param handler Custom output handler.
	 * @return Result of execution.
	 * @throws java.io.IOException If an error occurred during operation.
	 */
	CommandResult execute(Command command, OutputHandler handler) throws IOException;

	/**
	 * Start command line and return associated process.
	 * This process will be used to:
	 * - Read output.
	 * - Write arguments.
	 *
	 * @param command Command.
	 * @return Process.
	 * @throws java.io.IOException If an error occurred during operation.
	 */
	CommandProcess start(Command command) throws IOException ;
}
