/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client;

import com.github.mjeanroy.junit.servers.commons.EncoderUtils;
import com.github.mjeanroy.junit.servers.commons.Preconditions;
import com.github.mjeanroy.junit.servers.commons.ToStringBuilder;
import java.util.Objects;

public class HttpParameter {
    private final String name;
    private final String value;

    public static HttpParameter param(String name, String value) {
        return new HttpParameter(name, value);
    }

    private HttpParameter(String name, String value) {
        this.name = Preconditions.notBlank(name, "name");
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getEncodedName() {
        return EncoderUtils.urlEncode(this.name);
    }

    public String getEncodedValue() {
        return this.value == null ? null : EncoderUtils.urlEncode(this.value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HttpParameter) {
            HttpParameter p = (HttpParameter)o;
            return Objects.equals(this.name, p.name) && Objects.equals(this.value, p.value);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("name", this.name).append("value", this.value).build();
    }
}

