/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client.impl.apache;

import com.github.mjeanroy.junit.servers.client.HttpClient;
import com.github.mjeanroy.junit.servers.client.HttpClientConfiguration;
import com.github.mjeanroy.junit.servers.client.HttpMethod;
import com.github.mjeanroy.junit.servers.client.HttpRequest;
import com.github.mjeanroy.junit.servers.client.HttpUrl;
import com.github.mjeanroy.junit.servers.client.impl.AbstractHttpClient;
import com.github.mjeanroy.junit.servers.client.impl.apache.ApacheHttpRequest;
import com.github.mjeanroy.junit.servers.commons.Preconditions;
import com.github.mjeanroy.junit.servers.exceptions.HttpClientException;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class ApacheHttpClient
extends AbstractHttpClient
implements HttpClient {
    private final AtomicBoolean destroyed;
    private final CloseableHttpClient client;

    @Deprecated
    public static ApacheHttpClient newApacheHttpClient(EmbeddedServer<?> server, CloseableHttpClient client) {
        return new ApacheHttpClient(HttpClientConfiguration.defaultConfiguration(), server, client);
    }

    public static ApacheHttpClient defaultApacheHttpClient(EmbeddedServer<?> server) {
        HttpClientConfiguration configuration = HttpClientConfiguration.defaultConfiguration();
        return ApacheHttpClient.newApacheHttpClient(configuration, server);
    }

    public static ApacheHttpClient newApacheHttpClient(HttpClientConfiguration configuration, EmbeddedServer<?> server) {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        if (!configuration.isFollowRedirect()) {
            httpClientBuilder.disableRedirectHandling();
        }
        CloseableHttpClient client = httpClientBuilder.build();
        return new ApacheHttpClient(configuration, server, client);
    }

    private ApacheHttpClient(HttpClientConfiguration configuration, EmbeddedServer<?> server, CloseableHttpClient client) {
        super(configuration, server);
        this.client = Preconditions.notNull(client, "client");
        this.destroyed = new AtomicBoolean(false);
    }

    @Override
    protected HttpRequest buildRequest(HttpMethod httpMethod, HttpUrl endpoint) {
        return new ApacheHttpRequest((org.apache.http.client.HttpClient)this.client, httpMethod, endpoint);
    }

    @Override
    public void destroy() {
        if (this.destroyed.compareAndSet(false, true)) {
            try {
                this.client.close();
            }
            catch (IOException ex) {
                throw new HttpClientException(ex);
            }
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed.get();
    }
}

