/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.client.impl.apache;

import com.github.mjeanroy.junit.servers.client.HttpHeader;
import com.github.mjeanroy.junit.servers.client.HttpResponse;
import com.github.mjeanroy.junit.servers.client.impl.AbstractHttpResponse;
import com.github.mjeanroy.junit.servers.commons.Preconditions;
import com.github.mjeanroy.junit.servers.commons.ToStringBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;

final class ApacheHttpResponse
extends AbstractHttpResponse
implements HttpResponse {
    private final org.apache.http.HttpResponse response;

    ApacheHttpResponse(org.apache.http.HttpResponse response, long duration) {
        super(duration);
        this.response = Preconditions.notNull(response, "Response");
    }

    @Override
    public int status() {
        return this.response.getStatusLine().getStatusCode();
    }

    @Override
    protected String readResponseBody() throws IOException {
        HttpEntity entity = this.response.getEntity();
        return entity == null ? "" : EntityUtils.toString((HttpEntity)entity);
    }

    @Override
    public Collection<HttpHeader> getHeaders() {
        Header[] headers = this.response.getAllHeaders();
        if (headers == null || headers.length == 0) {
            return Collections.emptyList();
        }
        HashMap<String, HttpHeader.Builder> builders = new HashMap<String, HttpHeader.Builder>();
        for (Header h : headers) {
            String name = h.getName();
            String value = h.getValue();
            String key = h.getName().toLowerCase();
            HttpHeader.Builder current = (HttpHeader.Builder)builders.get(key);
            if (current == null) {
                current = HttpHeader.builder(name);
                builders.put(key, current);
            }
            current.addValue(value);
        }
        ArrayList<HttpHeader> results = new ArrayList<HttpHeader>(builders.size());
        for (HttpHeader.Builder header : builders.values()) {
            results.add(header.build());
        }
        return Collections.unmodifiableList(results);
    }

    @Override
    public HttpHeader getHeader(String name) {
        Header[] values = this.response.getHeaders(name);
        if (values == null || values.length == 0) {
            return null;
        }
        HttpHeader.Builder builder = HttpHeader.builder(name);
        for (Header header : values) {
            builder.addValue(header.getValue());
        }
        return builder.build();
    }

    public String toString() {
        return ToStringBuilder.create(this.getClass()).append("duration", this.getRequestDuration()).append("response", this.response).build();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ApacheHttpResponse) {
            ApacheHttpResponse r = (ApacheHttpResponse)o;
            return super.equals(o) && Objects.equals(this.response, r.response);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.response);
    }

    @Override
    protected boolean canEqual(AbstractHttpResponse o) {
        return o instanceof ApacheHttpResponse;
    }
}

