/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.commons;

import com.github.mjeanroy.junit.servers.commons.Preconditions;
import java.net.URL;

public class CompositeClassLoader
extends ClassLoader {
    private final ClassLoader fallback;

    public CompositeClassLoader(ClassLoader parent, ClassLoader fallback) {
        super(parent);
        this.fallback = Preconditions.notNull(fallback, "Fallback classloader");
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.fallback.loadClass(name);
    }

    @Override
    protected URL findResource(String name) {
        return this.fallback.getResource(name);
    }
}

