/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.engine;

import com.github.mjeanroy.junit.servers.commons.ReflectionUtils;
import com.github.mjeanroy.junit.servers.engine.AbstractTestLifeCycle;
import com.github.mjeanroy.junit.servers.engine.AnnotationHandler;
import com.github.mjeanroy.junit.servers.engine.ConfigurationAnnotationHandler;
import com.github.mjeanroy.junit.servers.engine.HttpClientAnnotationHandler;
import com.github.mjeanroy.junit.servers.engine.ServerAnnotationHandler;
import com.github.mjeanroy.junit.servers.engine.TestLifeCycleAdapter;
import com.github.mjeanroy.junit.servers.servers.AbstractConfiguration;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;

public class AnnotationsHandlerTestLifeCycleAdapter
extends AbstractTestLifeCycle
implements TestLifeCycleAdapter {
    private final List<AnnotationHandler> handlers;

    public AnnotationsHandlerTestLifeCycleAdapter(EmbeddedServer<?> server, AbstractConfiguration configuration) {
        this.handlers = Arrays.asList(ServerAnnotationHandler.newServerAnnotationHandler(server), ConfigurationAnnotationHandler.newConfigurationAnnotationHandler(configuration), HttpClientAnnotationHandler.newHttpClientAnnotationHandler(server));
    }

    @Override
    public void beforeEach(Object target) {
        this.process(target, true);
    }

    @Override
    public void afterEach(Object target) {
        this.process(target, false);
    }

    private void process(Object target, boolean before) {
        List<Field> fields = ReflectionUtils.findAllFields(target.getClass());
        for (Field field : fields) {
            for (AnnotationHandler handler : this.handlers) {
                this.processField(target, handler, field, before);
            }
        }
    }

    private void processField(Object target, AnnotationHandler handler, Field field, boolean before) {
        for (Annotation annotation : field.getAnnotations()) {
            if (!handler.support(annotation)) continue;
            if (before) {
                handler.before(target, field);
                continue;
            }
            handler.after(target, field);
        }
    }
}

