/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.engine;

import com.github.mjeanroy.junit.servers.client.HttpClient;
import com.github.mjeanroy.junit.servers.client.HttpClientConfiguration;
import com.github.mjeanroy.junit.servers.client.HttpClientStrategy;
import com.github.mjeanroy.junit.servers.commons.Preconditions;
import com.github.mjeanroy.junit.servers.engine.AbstractTestLifeCycle;
import com.github.mjeanroy.junit.servers.engine.Servers;
import com.github.mjeanroy.junit.servers.engine.TestLifeCycleAdapter;
import com.github.mjeanroy.junit.servers.servers.AbstractConfiguration;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;
import java.util.HashMap;
import java.util.Map;

public final class EmbeddedServerTestLifeCycleAdapter
extends AbstractTestLifeCycle
implements TestLifeCycleAdapter {
    private final EmbeddedServer<?> server;
    private final Map<HttpClientStrategy, HttpClient> clients;

    public EmbeddedServerTestLifeCycleAdapter() {
        this((AbstractConfiguration)null);
    }

    public EmbeddedServerTestLifeCycleAdapter(AbstractConfiguration configuration) {
        this(Servers.instantiate(configuration));
    }

    public EmbeddedServerTestLifeCycleAdapter(EmbeddedServer<?> server) {
        this.server = Preconditions.notNull(server, "server");
        this.clients = new HashMap<HttpClientStrategy, HttpClient>();
    }

    @Override
    public void beforeAll() {
        this.start();
    }

    @Override
    public void afterAll() {
        this.stop();
    }

    public void start() {
        this.server.start();
    }

    public void stop() {
        this.stopServer();
        this.closeOpenedClients();
    }

    private void stopServer() {
        this.server.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOpenedClients() {
        Map<HttpClientStrategy, HttpClient> map = this.clients;
        synchronized (map) {
            for (HttpClient client : this.clients.values()) {
                if (client.isDestroyed()) continue;
                client.destroy();
            }
            this.clients.clear();
        }
    }

    public void restart() {
        this.server.restart();
    }

    public boolean isStarted() {
        return this.server.isStarted();
    }

    public String getScheme() {
        return this.server.getScheme();
    }

    public String getHost() {
        return this.server.getHost();
    }

    public int getPort() {
        return this.server.getPort();
    }

    public String getPath() {
        return this.server.getPath();
    }

    public String getUrl() {
        return this.server.getUrl();
    }

    public EmbeddedServer<?> getServer() {
        return this.server;
    }

    public HttpClient getClient() {
        return this.openClient(HttpClientStrategy.AUTO);
    }

    public HttpClient getClient(HttpClientStrategy strategy) {
        return this.openClient(Preconditions.notNull(strategy, "strategy"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpClient openClient(HttpClientStrategy strategy) {
        Map<HttpClientStrategy, HttpClient> map = this.clients;
        synchronized (map) {
            if (!this.clients.containsKey((Object)strategy) || this.clients.get((Object)strategy).isDestroyed()) {
                HttpClientConfiguration configuration = HttpClientConfiguration.defaultConfiguration();
                HttpClient client = strategy.build(configuration, this.server);
                this.clients.put(strategy, client);
            }
            return this.clients.get((Object)strategy);
        }
    }
}

