/*
 * Decompiled with CFR 0.152.
 */
package com.github.mjeanroy.junit.servers.servers;

import com.github.mjeanroy.junit.servers.commons.Preconditions;
import com.github.mjeanroy.junit.servers.commons.UrlUtils;
import com.github.mjeanroy.junit.servers.servers.AbstractConfiguration;
import com.github.mjeanroy.junit.servers.servers.EmbeddedServer;
import com.github.mjeanroy.junit.servers.servers.Hook;
import com.github.mjeanroy.junit.servers.servers.ServerStatus;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class AbstractEmbeddedServer<S, T extends AbstractConfiguration>
implements EmbeddedServer<T> {
    private static final String DEFAULT_SCHEME = "http";
    private static final String DEFAULT_HOST = "localhost";
    public static final String SCHEME_SEPARATOR = "://";
    public static final String PORT_SEPARATOR = ":";
    protected final T configuration;
    private volatile ServerStatus status;
    private final Map<String, String> oldProperties;
    private static final Object lock = new Object();

    protected AbstractEmbeddedServer(T configuration) {
        this.configuration = (AbstractConfiguration)Preconditions.notNull(configuration, "configuration");
        this.status = ServerStatus.STOPPED;
        this.oldProperties = new LinkedHashMap<String, String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.status != ServerStatus.STARTED) {
            Object object = lock;
            synchronized (object) {
                if (this.status != ServerStatus.STARTED) {
                    this.status = ServerStatus.STARTING;
                    this.initEnvironment();
                    this.execHooks(true);
                    this.doStart();
                    this.status = ServerStatus.STARTED;
                    this.onStarted();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.status != ServerStatus.STOPPED) {
            Object object = lock;
            synchronized (object) {
                if (this.status != ServerStatus.STOPPED) {
                    this.status = ServerStatus.STOPPING;
                    this.execHooks(false);
                    this.doStop();
                    this.destroyEnvironment();
                    this.status = ServerStatus.STOPPED;
                }
            }
        }
    }

    @Override
    public boolean isStarted() {
        return this.status == ServerStatus.STARTED;
    }

    @Override
    public void restart() {
        this.stop();
        this.start();
    }

    @Override
    public int getPort() {
        return this.isStarted() ? this.doGetPort() : ((AbstractConfiguration)this.configuration).getPort();
    }

    @Override
    public String getPath() {
        return ((AbstractConfiguration)this.configuration).getPath();
    }

    private void initEnvironment() {
        for (Map.Entry<String, String> property : ((AbstractConfiguration)this.configuration).getEnvProperties().entrySet()) {
            String name = property.getKey();
            String newValue = property.getValue();
            String oldValue = System.getProperty(property.getKey());
            this.oldProperties.put(name, oldValue);
            System.setProperty(name, newValue);
        }
    }

    private void destroyEnvironment() {
        for (Map.Entry<String, String> property : ((AbstractConfiguration)this.configuration).getEnvProperties().entrySet()) {
            String name = property.getKey();
            String oldValue = this.oldProperties.get(name);
            this.oldProperties.remove(name);
            if (oldValue == null) {
                System.clearProperty(name);
                continue;
            }
            System.setProperty(name, oldValue);
        }
    }

    private void execHooks(boolean pre) {
        for (Hook hook : ((AbstractConfiguration)this.configuration).getHooks()) {
            if (pre) {
                hook.pre(this);
                continue;
            }
            hook.post(this);
        }
    }

    private void onStarted() {
        for (Hook hook : ((AbstractConfiguration)this.configuration).getHooks()) {
            hook.onStarted(this, this.getServletContext());
        }
    }

    @Override
    public String getScheme() {
        return DEFAULT_SCHEME;
    }

    @Override
    public String getHost() {
        return DEFAULT_HOST;
    }

    @Override
    public String getUrl() {
        String scheme = this.getScheme();
        String host = this.getHost();
        String port = String.valueOf(this.getPort());
        String path = UrlUtils.ensureAbsolutePath(this.getPath());
        int initialSize = scheme.length() + host.length() + port.length() + path.length() + SCHEME_SEPARATOR.length() + PORT_SEPARATOR.length();
        return new StringBuilder(initialSize).append(scheme).append(SCHEME_SEPARATOR).append(host).append(PORT_SEPARATOR).append(port).append(path).toString();
    }

    @Override
    public T getConfiguration() {
        return this.configuration;
    }

    public abstract S getDelegate();

    protected abstract void doStart();

    protected abstract void doStop();

    protected abstract int doGetPort();
}

