/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting;

import com.github.mkolisnyk.cucumber.reporting.CucumberBreakdownReport;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.BreakdownReportInfo;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.BreakdownTable;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportTypes;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberScenarioResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberStepResult;
import com.github.mkolisnyk.cucumber.runner.runtime.ExtendedRuntimeOptions;
import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.codehaus.plexus.util.StringUtils;
import org.junit.Assert;

public class CucumberFeatureMapReport
extends CucumberBreakdownReport {
    public CucumberFeatureMapReport() {
    }

    public CucumberFeatureMapReport(ExtendedRuntimeOptions extendedOptions) {
        super(extendedOptions);
    }

    private String drawScenario(CucumberScenarioResult scenario) {
        String output = String.format("<table><tr><td>%s</td></tr><tr><td><table>", scenario.getDescription());
        for (CucumberStepResult step : scenario.getSteps()) {
            output = output.concat(String.format("<tr><td><b>%s</b> %s</td></tr>", step.getKeyword(), step.getName()));
            if (StringUtils.isNotBlank((String)step.getDocString())) {
                output = output.concat(String.format("<tr><td><i>%s</i></td></tr>", step.getDocString()));
            }
            if (step.getRows() == null) continue;
            output = output + String.format(Locale.US, "<tr><td style=\"padding-left:20px\"><table>", step.getResult().getStatus());
            for (int i = 0; i < step.getRows().length; ++i) {
                output = output + "<tr>";
                for (int j = 0; j < step.getRows()[i].length; ++j) {
                    output = output + String.format(Locale.US, "<td>%s</td>", StringEscapeUtils.escapeHtml((String)step.getRows()[i][j]));
                }
                output = output + "</tr>";
            }
            output = output + "</table></td></tr>";
        }
        return output + "</table></td></tr></table>";
    }

    private Map<String, CucumberScenarioResult[]> splitScenariosByFeatures(CucumberScenarioResult[] scenarios) {
        HashMap<String, CucumberScenarioResult[]> result = new HashMap<String, CucumberScenarioResult[]>();
        for (CucumberScenarioResult scenario : scenarios) {
            String featureName = scenario.getFeature().getName();
            if (result.containsKey(featureName)) {
                result.put(featureName, (CucumberScenarioResult[])ArrayUtils.add((Object[])((Object[])result.get(featureName)), (Object)scenario));
                continue;
            }
            result.put(featureName, new CucumberScenarioResult[]{scenario});
        }
        return result;
    }

    private String drawCell(CucumberScenarioResult[] scenarios) {
        String output = "<td><ul>";
        int index = 0;
        Map<String, CucumberScenarioResult[]> resultsMap = this.splitScenariosByFeatures(scenarios);
        for (String featureName : resultsMap.keySet()) {
            output = output.concat(String.format("<li> <b>Feature:</b> %s <ul>", featureName));
            for (CucumberScenarioResult scenario : resultsMap.get(featureName)) {
                output = output.concat(String.format("<li> <a onclick=\"toggle('scenario%d')\"><b>Scenario:</b> %s</a>", index, scenario.getName()));
                output = output.concat(String.format("<div id=\"scenario%d\" style=\"display:none\">%s</div></li>", index, this.drawScenario(scenario)));
                ++index;
            }
            output = output.concat("</ul></li>");
        }
        output = output + "</ul></td>";
        return output;
    }

    @Override
    public void executeReport(BreakdownReportInfo info, BreakdownTable table, boolean toPDF) throws Exception {
        CucumberFeatureResult[] features = this.readFileContent(true);
        File outFile = new File(this.getOutputDirectory() + File.separator + this.getOutputName() + "-" + info.getReportSuffix() + ".html");
        FileUtils.writeStringToFile((File)outFile, (String)this.generateBreakdownReport(features, info, table).replaceAll("\"hoverTable\"", "\"_hoverTable\""));
        if (toPDF) {
            this.exportToPDF(outFile, info.getReportSuffix());
        }
    }

    @Override
    protected String generateBody(BreakdownTable table, CucumberFeatureResult[] features) throws Exception {
        Object[] scenarios = new CucumberScenarioResult[]{};
        for (int j = 0; j < features.length; ++j) {
            Object[] elements = features[j].getElements();
            for (int i = 0; i < elements.length; ++i) {
                elements[i].setFeature(features[j]);
            }
            scenarios = (CucumberScenarioResult[])ArrayUtils.addAll((Object[])scenarios, (Object[])elements);
        }
        CucumberScenarioResult[][][] results = table.valuateScenarios((CucumberScenarioResult[])scenarios);
        String rowHeadings = this.generateRowHeading(table);
        String[] headingRows = rowHeadings.split("</tr>");
        Assert.assertEquals((long)(headingRows.length - 1), (long)results.length);
        String content = "";
        for (int i = 0; i < results.length; ++i) {
            String row = headingRows[i];
            for (int j = 0; j < results[i].length; ++j) {
                row = row.concat(this.drawCell(results[i][j]));
            }
            row = row.concat("</tr>");
            content = content.concat(row);
        }
        return content;
    }

    @Override
    public CucumberReportTypes getReportType() {
        return CucumberReportTypes.FEATURE_MAP_REPORT;
    }
}

