/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting;

import com.cedarsoftware.util.io.JsonReader;
import com.github.mkolisnyk.cucumber.reporting.interfaces.ConfigurableReport;
import com.github.mkolisnyk.cucumber.reporting.types.breakdown.BreakdownStats;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportError;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportLink;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportTypes;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import com.github.mkolisnyk.cucumber.reporting.types.retrospective.RetrospectiveBatch;
import com.github.mkolisnyk.cucumber.reporting.types.retrospective.RetrospectiveModel;
import com.github.mkolisnyk.cucumber.reporting.utils.helpers.FolderUtils;
import com.github.mkolisnyk.cucumber.reporting.utils.helpers.StringConversionUtils;
import com.github.mkolisnyk.cucumber.runner.runtime.ExtendedRuntimeOptions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;

public class CucumberRetrospectiveOverviewReport
extends ConfigurableReport<RetrospectiveBatch> {
    public CucumberRetrospectiveOverviewReport() {
    }

    public CucumberRetrospectiveOverviewReport(ExtendedRuntimeOptions extendedOptions) {
        super(extendedOptions);
    }

    protected String getReportBase() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/consolidated-tmpl.html");
        String result = IOUtils.toString((InputStream)is);
        return result;
    }

    private BreakdownStats[] calculateStats(String[] files) throws Exception {
        Object[] result = new BreakdownStats[]{};
        for (String file : files) {
            CucumberFeatureResult[] features;
            BreakdownStats stat = new BreakdownStats();
            for (CucumberFeatureResult feature : features = this.readFileContent(file, true)) {
                feature.valuate();
                stat.addPassed(feature.getPassed());
                stat.addFailed(feature.getFailed());
                stat.addSkipped(feature.getSkipped() + feature.getUndefined());
            }
            result = (BreakdownStats[])ArrayUtils.add((Object[])result, (Object)stat);
        }
        return result;
    }

    private String drawBarChart(RetrospectiveModel model, BreakdownStats stats, int offset, int barSize) {
        double total = stats.getFailed() + stats.getPassed() + stats.getSkipped();
        double scale = 0.9;
        if (total > 0.0) {
            int passedRatio = (int)(0.9 * (double)model.getHeight() * ((double)stats.getPassed() / total));
            int failedRatio = (int)(0.9 * (double)model.getHeight() * ((double)stats.getFailed() / total));
            int skippedRatio = (int)(0.9 * (double)model.getHeight() * ((double)stats.getSkipped() / total));
            String content = String.format(Locale.US, "<rect x=\"%d\" y=\"%d\" width=\"%d\" height=\"%d\" stroke=\"black\" stroke-width=\"1\" fill=\"silver\"></rect><rect x=\"%d\" y=\"%d\" width=\"%d\" height=\"%d\" stroke=\"red\" stroke-width=\"1\" fill=\"red\"></rect><rect x=\"%d\" y=\"%d\" width=\"%d\" height=\"%d\" stroke=\"silver\" stroke-width=\"1\" fill=\"green\"></rect>", (int)((double)offset * 0.9 * (double)barSize), 0, (int)(0.9 * (double)barSize), skippedRatio, (int)((double)offset * 0.9 * (double)barSize), skippedRatio, (int)(0.9 * (double)barSize), failedRatio, (int)((double)offset * 0.9 * (double)barSize), failedRatio + skippedRatio, (int)(0.9 * (double)barSize), passedRatio);
            int scaleTicksCount = 5;
            int maxScaleValue = 100;
            int vOffset = 10;
            for (int i = 0; i <= 5; ++i) {
                content = content.concat(String.format(Locale.US, "<text x=\"%d\" y=\"%d\" font-size=\"12\">%d%%</text>", (int)((double)model.getWidth() * 0.9), (int)((double)i * 0.9 * (double)model.getHeight() / 5.0) + 10, 100 - i * 100 / 5));
                content = content.concat(String.format(Locale.US, "<line stroke-dasharray=\"10,10\" x1=\"0\" y1=\"%d\" x2=\"%d\" y2=\"%d\" style=\"stroke:darkgray;stroke-width:1\" />", (int)((double)i * 0.9 * (double)model.getHeight() / 5.0), (int)((double)model.getWidth() * 0.9), (int)((double)i * 0.9 * (double)model.getHeight() / 5.0)));
            }
            content = content.concat(String.format(Locale.US, "<text x=\"%d\" y=\"%d\" font-size=\"12\">%d</text>", (int)((double)offset * 0.9 * (double)barSize) + barSize / 2, (int)(0.9 * (double)model.getHeight()) + 10, offset + 1));
            return content;
        }
        return "";
    }

    private String drawGraph(RetrospectiveModel model, BreakdownStats[] stats) {
        String content = String.format(Locale.US, "<svg xmlns=\"http://www.w3.org/2000/svg\" version=\"1.1\" width=\"%d\" height=\"%d\">", model.getWidth(), model.getHeight());
        int offset = 0;
        int barSize = model.getWidth() / stats.length;
        for (BreakdownStats stat : stats) {
            content = content.concat(this.drawBarChart(model, stat, offset, barSize));
            ++offset;
        }
        content = content + "</svg>";
        return content;
    }

    private String generateRetrospectiveReport(RetrospectiveModel model, BreakdownStats[] stats) throws Exception {
        String result = this.getReportBase();
        result = result.replaceAll("__TITLE__", model.getTitle());
        if (model.getRefreshTimeout() > 0 && StringUtils.isNotBlank((CharSequence)model.getRedirectTo())) {
            String refreshHeader = String.format(Locale.US, "<meta http-equiv=\"Refresh\" content=\"%d; url=%s\" />", model.getRefreshTimeout(), model.getRedirectTo());
            result = result.replaceAll("__REFRESH__", refreshHeader);
        } else {
            result = result.replaceAll("__REFRESH__", "");
        }
        String reportContent = "<h1>" + model.getTitle() + "</h1>" + this.drawGraph(model, stats);
        reportContent = StringConversionUtils.replaceHtmlEntitiesWithCodes(reportContent);
        reportContent = reportContent.replaceAll("[$]", "&#36;");
        result = result.replaceAll("__REPORT__", reportContent);
        return result;
    }

    public void executeReport(RetrospectiveModel model, boolean aggregate, boolean toPDF) throws Exception {
        String[] files = FolderUtils.getFilesByMask(".", model.getMask());
        BreakdownStats[] stats = this.calculateStats(files);
        File outFile = new File(this.getOutputDirectory() + File.separator + this.getOutputName() + "-" + model.getReportSuffix() + ".html");
        FileUtils.writeStringToFile((File)outFile, (String)this.generateRetrospectiveReport(model, stats));
        if (toPDF) {
            this.exportToPDF(outFile, model.getReportSuffix());
        }
    }

    @Override
    public CucumberReportTypes getReportType() {
        return CucumberReportTypes.RETROSPECTIVE_OVERVIEW;
    }

    @Override
    public void validateParameters() {
        Assert.assertNotNull((String)this.constructErrorMessage(CucumberReportError.NO_OUTPUT_DIRECTORY, ""), (Object)this.getOutputDirectory());
        Assert.assertNotNull((String)this.constructErrorMessage(CucumberReportError.NO_OUTPUT_NAME, ""), (Object)this.getOutputName());
    }

    @Override
    public CucumberReportLink getReportDocLink() {
        return CucumberReportLink.RETROSPECTIVE_OVERVIEW_URL;
    }

    @Override
    public void execute(boolean aggregate, boolean toPDF) throws Exception {
    }

    @Override
    public void execute(RetrospectiveBatch batch, boolean aggregate, boolean toPDF) throws Exception {
        for (RetrospectiveModel model : batch.getModels()) {
            this.executeReport(model, aggregate, toPDF);
        }
    }

    @Override
    public void execute(File config, boolean aggregate, boolean toPDF) throws Exception {
        Assert.assertTrue((String)this.constructErrorMessage(CucumberReportError.NON_EXISTING_CONFIG_FILE, ""), (boolean)config.exists());
        this.validateParameters();
        String content = FileUtils.readFileToString((File)config);
        RetrospectiveBatch batch = null;
        try {
            batch = (RetrospectiveBatch)JsonReader.jsonToJava((String)content);
        }
        catch (Throwable e) {
            Assert.fail((String)this.constructErrorMessage(CucumberReportError.INVALID_CONFIG_FILE, ""));
        }
        this.execute(batch, aggregate, toPDF);
    }
}

