/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting;

import com.github.mkolisnyk.cucumber.reporting.CucumberResultsOverview;
import com.github.mkolisnyk.cucumber.reporting.types.beans.CoverageDataBean;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportLink;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportTypes;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberScenarioResult;
import com.github.mkolisnyk.cucumber.runner.runtime.ExtendedRuntimeOptions;
import java.io.File;
import org.apache.commons.lang3.ArrayUtils;

public class CucumberCoverageOverview
extends CucumberResultsOverview {
    private String[] includeCoverageTags = new String[0];
    private String[] excludeCoverageTags = new String[0];

    public CucumberCoverageOverview() {
    }

    public CucumberCoverageOverview(ExtendedRuntimeOptions extendedOptions) {
        super(extendedOptions);
        this.setExcludeCoverageTags(extendedOptions.getExcludeCoverageTags());
        this.setIncludeCoverageTags(extendedOptions.getIncludeCoverageTags());
    }

    public final String[] getIncludeCoverageTags() {
        return this.includeCoverageTags;
    }

    public final void setIncludeCoverageTags(String[] includeCoverageTagsValue) {
        this.includeCoverageTags = includeCoverageTagsValue == null ? new String[0] : includeCoverageTagsValue;
    }

    public final String[] getExcludeCoverageTags() {
        return this.excludeCoverageTags;
    }

    public final void setExcludeCoverageTags(String[] excludeCoverageTagsValue) {
        this.excludeCoverageTags = excludeCoverageTagsValue == null ? new String[0] : excludeCoverageTagsValue;
    }

    private String getFeatureStatus(CucumberFeatureResult result) {
        if (result.getStatus().equals("undefined") || result.getUndefined() > 0) {
            return "undefined";
        }
        return "passed";
    }

    private String getScenarioStatus(CucumberScenarioResult result) {
        if (result.getStatus().equals("undefined") || result.getUndefined() > 0) {
            return "undefined";
        }
        return "passed";
    }

    @Override
    public void execute(String[] formats) throws Exception {
        File outFile = this.getOutputHtmlFile();
        this.validateParameters();
        CucumberFeatureResult[] features = this.readFileContent(true);
        CoverageDataBean data = new CoverageDataBean();
        Object[] featureRows = new CoverageDataBean.FeatureStatusRow[]{};
        Object[] scenarioRows = new CoverageDataBean.ScenarioStatusRow[]{};
        for (CucumberFeatureResult feature : features) {
            feature.setIncludeCoverageTags(this.includeCoverageTags);
            feature.setExcludeCoverageTags(this.excludeCoverageTags);
            feature.valuate();
            CoverageDataBean.FeatureStatusRow featureRow = new CoverageDataBean().new CoverageDataBean.FeatureStatusRow();
            featureRow.setFeatureName(feature.getName());
            featureRow.setStatus(this.getFeatureStatus(feature));
            featureRow.setTags(feature.getAllTags(true));
            featureRow.setCovered(feature.getPassed() + feature.getFailed() + feature.getSkipped());
            featureRow.setNotCovered(feature.getUndefined());
            featureRows = (CoverageDataBean.FeatureStatusRow[])ArrayUtils.add((Object[])featureRows, (Object)featureRow);
            for (CucumberScenarioResult scenario : feature.getElements()) {
                CoverageDataBean.ScenarioStatusRow scenarioRow = new CoverageDataBean().new CoverageDataBean.ScenarioStatusRow();
                scenario.setIncludeCoverageTags(this.includeCoverageTags);
                scenario.setExcludeCoverageTags(this.excludeCoverageTags);
                scenario.valuate();
                scenarioRow.setFeatureName(scenario.getFeature().getName());
                scenarioRow.setScenarioName(scenario.getName());
                scenarioRow.setStatus(this.getScenarioStatus(scenario));
                scenarioRow.setCovered(scenario.getPassed() + scenario.getFailed() + scenario.getSkipped());
                scenarioRow.setNotCovered(scenario.getUndefined());
                scenarioRow.setTags((String[])ArrayUtils.addAll((Object[])scenario.getAllTags(), (Object[])scenario.getFeature().getAllTags(false)));
                scenarioRows = (CoverageDataBean.ScenarioStatusRow[])ArrayUtils.add((Object[])scenarioRows, (Object)scenarioRow);
            }
        }
        data.setFeatures((CoverageDataBean.FeatureStatusRow[])featureRows);
        data.setScenarios((CoverageDataBean.ScenarioStatusRow[])scenarioRows);
        this.generateReportFromTemplate(outFile, this.templateName(), data);
        this.export(outFile, this.reportSuffix(), formats, this.isImageExportable());
    }

    @Override
    public void execute() throws Exception {
        this.execute(new String[0]);
    }

    @Override
    public CucumberReportTypes getReportType() {
        return CucumberReportTypes.COVERAGE_OVERVIEW;
    }

    @Override
    public CucumberReportLink getReportDocLink() {
        return CucumberReportLink.COVERAGE_OVERVIEW_URL;
    }
}

