/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting;

import com.github.mkolisnyk.cucumber.reporting.CucumberResultsOverview;
import com.github.mkolisnyk.cucumber.reporting.types.beans.FeatureOverviewDataBean;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportLink;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportTypes;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import com.github.mkolisnyk.cucumber.runner.runtime.ExtendedRuntimeOptions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import org.apache.commons.io.IOUtils;

public class CucumberFeatureOverview
extends CucumberResultsOverview {
    public CucumberFeatureOverview() {
    }

    public CucumberFeatureOverview(ExtendedRuntimeOptions extendedOptions) {
        super(extendedOptions);
    }

    @Override
    public CucumberReportLink getReportDocLink() {
        return CucumberReportLink.FEATURE_OVERVIEW_URL;
    }

    @Override
    public CucumberReportTypes getReportType() {
        return CucumberReportTypes.FEATURE_OVERVIEW;
    }

    protected String getReportBase() throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/feature-overview-tmpl-2.html");
        String result = IOUtils.toString((InputStream)is);
        return result;
    }

    private String getStatusLetter(double rate) {
        String scale = "ABCDEF";
        int index = (int)((1.0 - rate) * (double)(scale.length() - 1));
        return scale.substring(index, index + 1);
    }

    private String getFeatureStatusLetter(CucumberFeatureResult feature) {
        feature.valuate();
        double rate = (double)feature.getPassed() / (double)(feature.getPassed() + feature.getFailed() + feature.getSkipped() + feature.getUndefined());
        return this.getStatusLetter(rate);
    }

    private double getOverallRate(CucumberFeatureResult[] results) {
        int[][] statuses = this.getStatuses(results);
        int[] scenarioStatuses = statuses[1];
        return (double)scenarioStatuses[0] / (double)(scenarioStatuses[0] + scenarioStatuses[1] + scenarioStatuses[2]);
    }

    @Override
    public void execute(String[] formats) throws Exception {
        this.execute(true, formats);
    }

    @Override
    public void execute() throws Exception {
        this.execute(true);
    }

    @Override
    public void execute(boolean aggregate, String[] formats) throws Exception {
        int maxRate = 100;
        this.validateParameters();
        CucumberFeatureResult[] features = this.readFileContent(aggregate);
        File outFile = this.getOutputHtmlFile();
        FeatureOverviewDataBean data = new FeatureOverviewDataBean();
        LinkedHashMap<String, String> featureData = new LinkedHashMap<String, String>();
        for (int i = 0; i < features.length; ++i) {
            features[i].valuate();
            featureData.put(features[i].getName(), this.getFeatureStatusLetter(features[i]));
        }
        data.setFeatureRate(featureData);
        double rate = this.getOverallRate(features);
        data.setPassRate((int)(rate * 100.0));
        data.setOverallRate(this.getStatusLetter(rate));
        this.generateReportFromTemplate(outFile, this.templateName(), data);
        this.export(outFile, this.reportSuffix(), formats, this.isImageExportable());
    }
}

