/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting;

import com.github.mkolisnyk.cucumber.reporting.interfaces.KECompatibleReport;
import com.github.mkolisnyk.cucumber.reporting.types.OverviewStats;
import com.github.mkolisnyk.cucumber.reporting.types.beans.OverviewDataBean;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportError;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportLink;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportTypes;
import com.github.mkolisnyk.cucumber.reporting.types.knownerrors.KnownErrorsModel;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberScenarioResult;
import com.github.mkolisnyk.cucumber.runner.runtime.ExtendedRuntimeOptions;
import java.io.File;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;

public class CucumberResultsOverview
extends KECompatibleReport {
    public CucumberResultsOverview() {
    }

    public CucumberResultsOverview(ExtendedRuntimeOptions extendedOptions) {
        super(extendedOptions);
    }

    @Override
    public int[][] getStatuses(CucumberFeatureResult[] results) {
        int kePosition = 3;
        int[][] statuses = new int[][]{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}};
        for (CucumberFeatureResult result : results) {
            if (result.getStatus().trim().equalsIgnoreCase("passed")) {
                int[] nArray = statuses[0];
                nArray[0] = nArray[0] + 1;
            } else if (result.getStatus().trim().equalsIgnoreCase("failed")) {
                int[] nArray = statuses[0];
                nArray[1] = nArray[1] + 1;
            } else if (result.getStatus().trim().equalsIgnoreCase("known")) {
                int[] nArray = statuses[0];
                nArray[3] = nArray[3] + 1;
            } else {
                int[] nArray = statuses[0];
                nArray[2] = nArray[2] + 1;
            }
            for (CucumberScenarioResult element : result.getElements()) {
                if (element.getStatus().trim().equalsIgnoreCase("passed")) {
                    int[] nArray = statuses[1];
                    nArray[0] = nArray[0] + 1;
                } else if (element.getStatus().trim().equalsIgnoreCase("failed")) {
                    int[] nArray = statuses[1];
                    nArray[1] = nArray[1] + 1;
                } else if (element.getStatus().trim().equalsIgnoreCase("known")) {
                    int[] nArray = statuses[1];
                    nArray[3] = nArray[3] + 1;
                } else {
                    int[] nArray = statuses[1];
                    nArray[2] = nArray[2] + 1;
                }
                int[] nArray = statuses[2];
                nArray[0] = nArray[0] + element.getPassed();
                int[] nArray2 = statuses[2];
                nArray2[1] = nArray2[1] + element.getFailed();
                int[] nArray3 = statuses[2];
                nArray3[2] = nArray3[2] + (element.getSkipped() + element.getUndefined());
                int[] nArray4 = statuses[2];
                nArray4[3] = nArray4[3] + element.getKnown();
            }
        }
        return statuses;
    }

    @Override
    public boolean isImageExportable() {
        return true;
    }

    protected void executeOverviewReport(String reportSuffix) throws Exception {
        this.executeOverviewReport(reportSuffix, new String[0]);
    }

    protected void executeOverviewReport(String reportSuffix, String[] formats) throws Exception {
        this.executeOverviewReport(null, reportSuffix, formats);
    }

    protected void executeOverviewReport(KnownErrorsModel batch, CucumberFeatureResult[] features, String reportSuffix, String[] formats) throws Exception {
        this.validateParameters();
        if (batch != null) {
            for (CucumberFeatureResult feature : features) {
                feature.valuateKnownErrors(batch);
            }
        }
        File outFile = new File(this.getOutputDirectory() + File.separator + this.getOutputName() + "-" + reportSuffix + ".html");
        OverviewDataBean data = new OverviewDataBean();
        Object[] featureRows = new OverviewDataBean.FeatureStatusRow[]{};
        Object[] scenarioRows = new OverviewDataBean.ScenarioStatusRow[]{};
        for (CucumberFeatureResult feature : features) {
            feature.valuate();
            if (batch != null) {
                feature.valuateKnownErrors(batch);
            }
            OverviewDataBean.FeatureStatusRow featureRow = new OverviewDataBean.FeatureStatusRow(data);
            featureRow.setFeatureName(feature.getName());
            OverviewStats stats = new OverviewStats();
            stats.valuate(feature);
            featureRow.setStats(stats);
            featureRow.setDuration(String.format("%.2f", Float.valueOf(feature.getDuration())));
            featureRow.setStatus(feature.getStatus());
            featureRows = (OverviewDataBean.FeatureStatusRow[])ArrayUtils.add((Object[])featureRows, (Object)featureRow);
            for (CucumberScenarioResult scenario : feature.getElements()) {
                OverviewDataBean.ScenarioStatusRow scenarioRow = new OverviewDataBean.ScenarioStatusRow(data);
                scenario.valuate();
                OverviewStats scenarioStats = new OverviewStats();
                scenarioStats.valuate(scenario);
                scenarioRow.setDuration(String.format("%.2f", scenario.getDuration()));
                scenarioRow.setFeatureName(feature.getName());
                scenarioRow.setRetries(scenario.getRerunAttempts());
                scenarioRow.setScenarioName(scenario.getName());
                scenarioRow.setStats(scenarioStats);
                scenarioRow.setStatus(scenario.getStatus());
                scenarioRows = (OverviewDataBean.ScenarioStatusRow[])ArrayUtils.add((Object[])scenarioRows, (Object)scenarioRow);
            }
        }
        OverviewStats stats = new OverviewStats();
        stats.valuate(features);
        data.setOverallStats(stats);
        data.setFeatures((OverviewDataBean.FeatureStatusRow[])featureRows);
        data.setScenarios((OverviewDataBean.ScenarioStatusRow[])scenarioRows);
        this.generateReportFromTemplate(outFile, this.templateName(), data);
        this.export(outFile, reportSuffix, formats, this.isImageExportable());
        try {
            outFile = new File(this.getOutputDirectory() + File.separator + this.getOutputName() + "-" + reportSuffix + "-dump.xml");
            this.dumpOverviewStats(outFile, features);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return;
        }
    }

    protected void executeOverviewReport(KnownErrorsModel batch, String reportSuffix, String[] formats) throws Exception {
        this.validateParameters();
        CucumberFeatureResult[] features = this.readFileContent(true);
        this.executeOverviewReport(batch, features, reportSuffix, formats);
    }

    @Override
    public CucumberReportTypes getReportType() {
        return CucumberReportTypes.RESULTS_OVERVIEW;
    }

    @Override
    public void validateParameters() {
        Assert.assertNotNull((String)this.constructErrorMessage(CucumberReportError.NO_SOURCE_FILE, ""), (Object)this.getSourceFiles());
        Assert.assertNotNull((String)this.constructErrorMessage(CucumberReportError.NO_OUTPUT_DIRECTORY, ""), (Object)this.getOutputDirectory());
        Assert.assertNotNull((String)this.constructErrorMessage(CucumberReportError.NO_OUTPUT_NAME, ""), (Object)this.getOutputName());
        for (String sourceFile : this.getSourceFiles()) {
            Assert.assertNotNull((String)this.constructErrorMessage(CucumberReportError.NO_SOURCE_FILE, ""), (Object)sourceFile);
            File path = new File(sourceFile);
            Assert.assertTrue((String)(this.constructErrorMessage(CucumberReportError.NON_EXISTING_SOURCE_FILE, "") + ". Was looking for path: \"" + path.getAbsolutePath() + "\""), (boolean)path.exists());
        }
    }

    @Override
    public CucumberReportLink getReportDocLink() {
        return CucumberReportLink.RESULTS_OVERVIEW_URL;
    }

    @Override
    public void execute(String[] formats) throws Exception {
        this.executeOverviewReport(this.reportSuffix(), formats);
    }

    @Override
    public void execute(boolean aggregate, String[] formats) throws Exception {
        this.executeOverviewReport(this.reportSuffix(), formats);
    }

    @Override
    public void execute(KnownErrorsModel batch, boolean aggregate, String[] formats) throws Exception {
        this.executeOverviewReport(batch, this.reportSuffix(), formats);
    }

    @Override
    public void execute(KnownErrorsModel batch, CucumberFeatureResult[] features, boolean aggregate, String[] formats) throws Exception {
        this.executeOverviewReport(batch, features, this.reportSuffix(), formats);
    }

    @Override
    public void execute(boolean aggregate, CucumberFeatureResult[] features, String[] formats) throws Exception {
        this.executeOverviewReport(null, features, this.reportSuffix(), formats);
    }
}

