/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting;

import com.cedarsoftware.util.io.JsonObject;
import com.github.mkolisnyk.cucumber.reporting.interfaces.AggregatedReport;
import com.github.mkolisnyk.cucumber.reporting.types.beans.SplitFeatureDataBean;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportLink;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportTypes;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberScenarioResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberTagResults;
import java.io.File;
import java.util.UUID;

public class CucumberSplitFeature
extends AggregatedReport {
    @Override
    public void execute(boolean aggregate, String[] formats) throws Exception {
        CucumberFeatureResult[] features = this.readFileContent(aggregate);
        this.execute(aggregate, features, formats);
    }

    @Override
    public void execute(String[] formats) throws Exception {
        this.execute(false, formats);
    }

    @Override
    public CucumberReportTypes getReportType() {
        return CucumberReportTypes.SPLIT_FEATURE;
    }

    @Override
    public CucumberReportLink getReportDocLink() {
        return null;
    }

    @Override
    public void validateParameters() {
    }

    @Override
    public void execute(boolean aggregate, CucumberFeatureResult[] features, String[] formats) throws Exception {
        this.validateParameters();
        for (CucumberFeatureResult feature : features) {
            JsonObject json = new JsonObject();
            json.put((Object)"name", (Object)("@" + UUID.randomUUID().toString()));
            CucumberTagResults[] tags = new CucumberTagResults[]{new CucumberTagResults((JsonObject<String, Object>)json)};
            feature.setTags(tags);
            for (CucumberScenarioResult scenario : feature.getElements()) {
                File outFile = new File(this.getOutputDirectory() + File.separator + scenario.getId().replaceAll("[^A-Za-z0-9]", "_") + ".feature");
                SplitFeatureDataBean data = new SplitFeatureDataBean();
                data.setScenario(scenario);
                this.generateReportFromTemplate(outFile, this.templateName(), data);
            }
        }
    }
}

