/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting;

import com.cedarsoftware.util.io.JsonObject;
import com.cedarsoftware.util.io.JsonReader;
import com.github.mkolisnyk.cucumber.reporting.interfaces.SimpleReport;
import com.github.mkolisnyk.cucumber.reporting.types.beans.UsageDataBean;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportError;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportLink;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportTypes;
import com.github.mkolisnyk.cucumber.reporting.types.usage.CucumberStep;
import com.github.mkolisnyk.cucumber.reporting.types.usage.CucumberStepSource;
import com.github.mkolisnyk.cucumber.reporting.utils.helpers.MapUtils;
import com.github.mkolisnyk.cucumber.runner.runtime.ExtendedRuntimeOptions;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.lang.ArrayUtils;
import org.junit.Assert;

public class CucumberUsageReporting
extends SimpleReport {
    private String[] jsonUsageFiles;

    public CucumberUsageReporting() {
    }

    public CucumberUsageReporting(ExtendedRuntimeOptions extendedOptions) {
        super(extendedOptions);
        this.setJsonUsageFiles(extendedOptions.getJsonUsageReportPaths());
    }

    public String getDescription(Locale arg0) {
        return "HTML formatted Cucumber keywords usage report";
    }

    public String getName(Locale arg0) {
        return "Cucumber usage report";
    }

    public String getJsonUsageFile() {
        return this.jsonUsageFiles[0];
    }

    public void setJsonUsageFile(String jsonUsageFileValue) {
        this.jsonUsageFiles = new String[]{jsonUsageFileValue};
    }

    public String[] getJsonUsageFiles() {
        return this.jsonUsageFiles;
    }

    public void setJsonUsageFiles(String[] jsonUsageFilesValue) {
        this.jsonUsageFiles = jsonUsageFilesValue;
    }

    public LinkedHashMap<String, Integer> calculateStepsUsageScore(CucumberStepSource[] sources) {
        LinkedHashMap map = new LinkedHashMap();
        for (CucumberStepSource source : sources) {
            int totalSteps = 0;
            for (CucumberStep step : source.getSteps()) {
                totalSteps += step.getDurations().length;
            }
            map.put(source.getSource(), totalSteps);
        }
        map = (LinkedHashMap)MapUtils.sortByValue(map);
        return map;
    }

    public SortedMap<Integer, Integer> calculateStepsUsageCounts(CucumberStepSource[] sources) {
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        for (CucumberStepSource source : sources) {
            int stepsCount = 0;
            for (CucumberStep step : source.getSteps()) {
                stepsCount += step.getDurations().length;
            }
            if (!map.containsKey(stepsCount)) {
                map.put(stepsCount, 1);
                continue;
            }
            int prevNum = (Integer)map.get(stepsCount);
            map.remove(stepsCount);
            map.put(stepsCount, ++prevNum);
        }
        return map;
    }

    public double calculateStepsUsageAverage(SortedMap<Integer, Integer> statistics) {
        int totalSteps = 0;
        int totalUniqueSteps = 0;
        for (int i : statistics.keySet()) {
            totalSteps += i * (Integer)statistics.get(i);
            totalUniqueSteps += ((Integer)statistics.get(i)).intValue();
        }
        if (totalUniqueSteps == 0) {
            totalUniqueSteps = 1;
        }
        return (double)totalSteps / (double)totalUniqueSteps;
    }

    public int calculateStepsUsageMedian(SortedMap<Integer, Integer> statistics) {
        int totalSteps = 0;
        int usedSteps = 0;
        int median = 0;
        for (int i : statistics.keySet()) {
            totalSteps += ((Integer)statistics.get(i)).intValue();
        }
        for (int i : statistics.keySet()) {
            if ((usedSteps += ((Integer)statistics.get(i)).intValue()) * 2 < totalSteps) continue;
            median = i;
            break;
        }
        return median;
    }

    public int calculateTotalSteps(SortedMap<Integer, Integer> statistics) {
        int totalSteps = 0;
        for (int i : statistics.keySet()) {
            totalSteps += i * (Integer)statistics.get(i);
        }
        return totalSteps;
    }

    public int calculateUsedSteps(SortedMap<Integer, Integer> statistics) {
        int usedSteps = 0;
        for (int i : statistics.keySet()) {
            usedSteps += ((Integer)statistics.get(i)).intValue();
        }
        return usedSteps;
    }

    public int calculateStepsUsageMax(SortedMap<Integer, Integer> statistics) {
        int max = 0;
        for (int i : statistics.keySet()) {
            max = Math.max(max, (Integer)statistics.get(i));
        }
        return max;
    }

    private CucumberStepSource getSourceByString(CucumberStepSource[] sources, String text) {
        for (CucumberStepSource source : sources) {
            if (!source.getSource().equals(text)) continue;
            return source;
        }
        return null;
    }

    public int getDurationGroupsCount(CucumberStepSource source) {
        int minimalDurations = 5;
        int minimalDurationSize = 3;
        int maxDurationGroups = 10;
        List<Double> durations = source.getDurations();
        if (durations.size() <= 5) {
            return 0;
        }
        if (durations.size() < 30) {
            return durations.size() / 3;
        }
        return 10;
    }

    public int[] getFrequencyData(CucumberStepSource source) {
        int minimalDurations = 5;
        int[] result = new int[]{};
        List<Double> durations = source.getDurations();
        if (durations.size() <= 5) {
            return result;
        }
        double minDuration = this.getMinDuration(source);
        double maxDuration = this.getMaxDuration(source);
        int count = this.getDurationGroupsCount(source);
        result = new int[count];
        for (int i = 0; i < count; ++i) {
            result[i] = 0;
        }
        double step = (maxDuration - minDuration) / (double)count;
        for (Double duration : durations) {
            int index = (int)((duration - minDuration) / step);
            if (index >= count) {
                index = count - 1;
            }
            result[index] = result[index] + 1;
        }
        return result;
    }

    private Double getMaxDuration(CucumberStepSource source) {
        List<Double> durations = source.getDurations();
        double maxDuration = durations.get(0);
        for (Double duration : durations) {
            maxDuration = Math.max(maxDuration, duration);
        }
        return maxDuration;
    }

    private Double getMinDuration(CucumberStepSource source) {
        List<Double> durations = source.getDurations();
        double minDuration = durations.get(0);
        for (Double duration : durations) {
            minDuration = Math.min(minDuration, duration);
        }
        return minDuration;
    }

    private double variance(List<Double> durations, double average) {
        double result = 0.0;
        for (double duration : durations) {
            result += (duration - average) * (duration - average);
        }
        if (durations.size() > 0) {
            result /= (double)durations.size();
        }
        return result;
    }

    private double skewness(List<Double> durations, double average) {
        double variance;
        double result = 0.0;
        double precision = 1.0E-9;
        double extand = 1.5;
        for (double duration : durations) {
            result += (duration - average) * (duration - average) * (duration - average);
        }
        if (durations.size() > 0) {
            result /= (double)durations.size();
        }
        if (Math.abs(variance = this.variance(durations, average)) < 1.0E-9) {
            variance = 1.0;
        }
        return result /= Math.pow(variance, 1.5);
    }

    public CucumberStepSource[] getStepSources(String filePath) throws Exception {
        FileInputStream fis = null;
        JsonReader jr = null;
        File file = new File(filePath);
        if (!file.exists() || !file.isFile()) {
            throw new FileNotFoundException();
        }
        fis = new FileInputStream(file);
        jr = new JsonReader((InputStream)fis, true);
        Object[] objs = (Object[])jr.readObject();
        CucumberStepSource[] sources = new CucumberStepSource[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            sources[i] = new CucumberStepSource((JsonObject<String, Object>)((JsonObject)objs[i]));
        }
        jr.close();
        fis.close();
        return sources;
    }

    private CucumberStepSource[] packStepSources(CucumberStepSource[] sources) {
        HashMap<String, CucumberStepSource> sourceMap = new HashMap<String, CucumberStepSource>();
        for (CucumberStepSource source : sources) {
            String key = source.getSource();
            if (sourceMap.containsKey(key)) {
                CucumberStepSource existing = (CucumberStepSource)sourceMap.get(key);
                source.addSteps(existing);
            }
            sourceMap.put(key, source);
        }
        CucumberStepSource[] result = new CucumberStepSource[sourceMap.size()];
        int index = 0;
        for (Map.Entry item : sourceMap.entrySet()) {
            result[index++] = (CucumberStepSource)item.getValue();
        }
        return result;
    }

    private void executeReport(String[] formats) throws Exception {
        try {
            Object[] sources = new CucumberStepSource[]{};
            for (String jsonUsageFile : this.getJsonUsageFiles()) {
                sources = (CucumberStepSource[])ArrayUtils.addAll((Object[])sources, (Object[])this.getStepSources(jsonUsageFile));
            }
            sources = this.packStepSources((CucumberStepSource[])sources);
            File report = this.getOutputHtmlFile();
            UsageDataBean data = new UsageDataBean();
            SortedMap<Integer, Integer> map = this.calculateStepsUsageCounts((CucumberStepSource[])sources);
            int max = this.calculateStepsUsageMax(map);
            int median = this.calculateStepsUsageMedian(map);
            double average = this.calculateStepsUsageAverage(map);
            data.setStepsUseMax(max);
            data.setStepsUseAverage(average);
            data.setStepsUseMedian(median);
            data.setUsageCounts(map);
            UsageDataBean.StepSourceData[] stepSourceData = new UsageDataBean.StepSourceData[sources.length];
            LinkedHashMap<String, Integer> stepsScoreMap = this.calculateStepsUsageScore((CucumberStepSource[])sources);
            int index = 0;
            for (String key : stepsScoreMap.keySet()) {
                CucumberStepSource source = this.getSourceByString((CucumberStepSource[])sources, key);
                stepSourceData[index] = data.new UsageDataBean.StepSourceData();
                stepSourceData[index].setSource(source);
                Double medianDuration = 0.0;
                Double totalDuration = 0.0;
                Double averageDuration = 0.0;
                Double minDuration = 0.0;
                Double maxDuration = 0.0;
                if (source != null) {
                    List<Double> durations = source.getDurations();
                    if (durations.size() > 0) {
                        Collections.sort(durations);
                        medianDuration = durations.get(durations.size() / 2);
                        for (Double duration : durations) {
                            totalDuration = totalDuration + duration;
                        }
                        averageDuration = totalDuration / (double)durations.size();
                        minDuration = Collections.min(durations);
                        maxDuration = Collections.max(durations);
                    }
                    stepSourceData[index].setTotalUsed(stepsScoreMap.get(key));
                    stepSourceData[index].setVariance(this.variance(durations, averageDuration));
                    stepSourceData[index].setSkewness(this.skewness(durations, averageDuration));
                    stepSourceData[index].setFrequencies(this.getFrequencyData(source));
                } else {
                    stepSourceData[index].setTotalUsed(0);
                    stepSourceData[index].setVariance(0.0);
                    stepSourceData[index].setSkewness(0.0);
                    stepSourceData[index].setFrequencies(new int[0]);
                }
                stepSourceData[index].setAverageDuration(averageDuration);
                stepSourceData[index].setMaxDuration(maxDuration);
                stepSourceData[index].setMedianDuration(medianDuration);
                stepSourceData[index].setMinDuration(minDuration);
                stepSourceData[index].setTotalDuration(totalDuration);
                ++index;
            }
            data.setStepsData(stepSourceData);
            this.generateReportFromTemplate(report, this.templateName(), data);
            this.export(report, this.reportSuffix(), formats, this.isImageExportable());
        }
        catch (Exception e) {
            throw new Exception("Error occured while generating Cucumber usage report", e);
        }
    }

    @Override
    public CucumberReportTypes getReportType() {
        return CucumberReportTypes.USAGE;
    }

    @Override
    public CucumberReportLink getReportDocLink() {
        return CucumberReportLink.USAGE_URL;
    }

    @Override
    public void validateParameters() {
        Assert.assertNotNull((String)this.constructErrorMessage(CucumberReportError.NO_SOURCE_FILE, ""), (Object)this.getJsonUsageFiles());
        Assert.assertNotNull((String)this.constructErrorMessage(CucumberReportError.NO_OUTPUT_DIRECTORY, ""), (Object)this.getOutputDirectory());
        Assert.assertNotNull((String)this.constructErrorMessage(CucumberReportError.NO_OUTPUT_NAME, ""), (Object)this.getOutputName());
        for (String sourceFile : this.getJsonUsageFiles()) {
            Assert.assertNotNull((String)this.constructErrorMessage(CucumberReportError.NO_SOURCE_FILE, ""), (Object)sourceFile);
            File path = new File(sourceFile);
            Assert.assertTrue((String)(this.constructErrorMessage(CucumberReportError.NON_EXISTING_SOURCE_FILE, "") + ". Was looking for path: \"" + path.getAbsolutePath() + "\""), (boolean)path.exists());
        }
    }

    @Override
    public void execute() throws Exception {
        this.execute(new String[0]);
    }

    @Override
    public void execute(String[] formats) throws Exception {
        this.validateParameters();
        this.executeReport(formats);
    }
}

