/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting.interfaces;

import com.cedarsoftware.util.io.JsonReader;
import com.github.mkolisnyk.cucumber.reporting.interfaces.AggregatedReport;
import com.github.mkolisnyk.cucumber.reporting.types.enums.CucumberReportError;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import com.github.mkolisnyk.cucumber.runner.runtime.ExtendedRuntimeOptions;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;

public abstract class ConfigurableReport<Model>
extends AggregatedReport {
    public ConfigurableReport() {
    }

    public ConfigurableReport(ExtendedRuntimeOptions extendedOptions) {
        super(extendedOptions);
    }

    public abstract void execute(Model var1, boolean var2, String[] var3) throws Exception;

    public abstract void execute(File var1, boolean var2, String[] var3) throws Exception;

    @Override
    public void execute(boolean aggregate, String[] formats) throws Exception {
    }

    @Override
    public void execute(String[] formats) throws Exception {
    }

    public void execute(Model batch, String[] formats) throws Exception {
        this.execute(batch, false, formats);
    }

    private Model getModelFromFile(File config) throws IOException {
        Assert.assertTrue((String)this.constructErrorMessage(CucumberReportError.NON_EXISTING_CONFIG_FILE, ""), (boolean)config.exists());
        String content = FileUtils.readFileToString((File)config);
        Object model = null;
        try {
            model = JsonReader.jsonToJava((String)content);
            Assert.assertNotEquals((Object)"java.lang.Object[]", (Object)model.getClass().getCanonicalName());
        }
        catch (Throwable e) {
            Assert.fail((String)this.constructErrorMessage(CucumberReportError.INVALID_CONFIG_FILE, ""));
        }
        return (Model)model;
    }

    public void execute(File config, String[] formats) throws Exception {
        Model model = this.getModelFromFile(config);
        this.execute(model, formats);
    }

    public void execute(File config, CucumberFeatureResult[] results, boolean aggregate, String[] formats) throws Exception {
        Model model = this.getModelFromFile(config);
        this.execute(model, results, aggregate, formats);
    }

    public abstract void execute(Model var1, CucumberFeatureResult[] var2, boolean var3, String[] var4) throws Exception;
}

