/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting.types.benchmark;

import com.github.mkolisnyk.cucumber.reporting.types.OverviewStats;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberFeatureResult;
import com.github.mkolisnyk.cucumber.reporting.types.result.CucumberScenarioResult;
import org.apache.commons.lang.ArrayUtils;

public class BenchmarkRowData {
    private String name;
    private OverviewStats[] results;

    public BenchmarkRowData() {
        this("", new OverviewStats[0]);
    }

    public BenchmarkRowData(String nameValue, OverviewStats[] resultsValue) {
        this.name = nameValue;
        this.results = resultsValue;
    }

    public String getName() {
        return this.name;
    }

    public OverviewStats[] getResults() {
        return this.results;
    }

    public void addFeatureResults(String featureId, CucumberFeatureResult[][] featureResults) {
        for (CucumberFeatureResult[] features : featureResults) {
            OverviewStats stats = new OverviewStats();
            for (CucumberFeatureResult feature : features) {
                if (!feature.getId().equals(featureId)) continue;
                feature.valuate();
                stats.addScenariosPassed(feature.getPassed());
                stats.addScenariosFailed(feature.getFailed());
                stats.addScenariosUndefined(feature.getUndefined() + feature.getSkipped());
                stats.addScenariosKnown(feature.getKnown());
                this.name = feature.getName();
                break;
            }
            this.results = (OverviewStats[])ArrayUtils.add((Object[])this.results, (Object)stats);
        }
    }

    public void addScenarioResults(String scenarioId, CucumberScenarioResult[][] scenarioResults) {
        for (CucumberScenarioResult[] scenarios : scenarioResults) {
            OverviewStats stats = new OverviewStats();
            for (CucumberScenarioResult scenario : scenarios) {
                if (!scenario.getId().equals(scenarioId)) continue;
                scenario.valuate();
                stats.addStepsPassed(scenario.getPassed());
                stats.addStepsFailed(scenario.getFailed());
                stats.addStepsUndefined(scenario.getUndefined() + scenario.getSkipped());
                stats.addStepsKnown(scenario.getKnown());
                this.name = scenario.getFeature().getName() + "/" + scenario.getName();
                break;
            }
            this.results = (OverviewStats[])ArrayUtils.add((Object[])this.results, (Object)stats);
        }
    }

    public static CucumberScenarioResult[][] toScenarioList(CucumberFeatureResult[][] featureResults) {
        CucumberScenarioResult[][] output = new CucumberScenarioResult[][]{};
        for (CucumberFeatureResult[] features : featureResults) {
            Object[] scenarios = new CucumberScenarioResult[]{};
            for (CucumberFeatureResult feature : features) {
                scenarios = (CucumberScenarioResult[])ArrayUtils.addAll((Object[])scenarios, (Object[])feature.getElements());
            }
            output = (CucumberScenarioResult[][])ArrayUtils.add((Object[])output, (Object)scenarios);
        }
        return output;
    }
}

