/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting.types.enums;

import java.util.HashMap;

public enum CucumberReportTypes {
    BREAKDOWN_REPORT("Breakdown Report"),
    BENCHMARK_REPORT("Benchmark Report"),
    CHARTS_REPORT("Charts Report"),
    CONSOLIDATED_REPORT("Consolidated Report"),
    COVERAGE_OVERVIEW("Coverage Overview"),
    CUSTOM_REPORT("Custom Report"),
    DETAILED_REPORT("Detailed Results Report"),
    FEATURE_MAP_REPORT("Feature Map Report"),
    FEATURE_OVERVIEW("Feature Overview Report"),
    KNOWN_ERRORS("Known Errors Report"),
    RESULTS_OVERVIEW("Results Overview Report"),
    RETROSPECTIVE_OVERVIEW("Retrospective Overview Report"),
    SYSTEM_INFO("System Information Report"),
    SPLIT_FEATURE("Split Feature"),
    USAGE("Usage Report");

    private String value;
    private static HashMap<CucumberReportTypes, String> reportSuffixes;
    private static HashMap<CucumberReportTypes, String> templateNames;

    private CucumberReportTypes(String valueData) {
        this.value = valueData;
    }

    public String toString() {
        return this.value;
    }

    public String suffix() {
        return reportSuffixes.get((Object)this);
    }

    public String template() {
        return templateNames.get((Object)this);
    }

    static {
        reportSuffixes = new HashMap<CucumberReportTypes, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(BREAKDOWN_REPORT, "breakdown");
                this.put(BENCHMARK_REPORT, "benchmark");
                this.put(CHARTS_REPORT, "charts-report");
                this.put(CONSOLIDATED_REPORT, "");
                this.put(COVERAGE_OVERVIEW, "coverage");
                this.put(CUSTOM_REPORT, "");
                this.put(DETAILED_REPORT, "test-results");
                this.put(FEATURE_MAP_REPORT, "");
                this.put(FEATURE_OVERVIEW, "feature-overview-chart");
                this.put(KNOWN_ERRORS, "known-errors");
                this.put(RESULTS_OVERVIEW, "feature-overview");
                this.put(RETROSPECTIVE_OVERVIEW, "");
                this.put(SYSTEM_INFO, "system-info");
                this.put(USAGE, "usage");
            }
        };
        templateNames = new HashMap<CucumberReportTypes, String>(){
            private static final long serialVersionUID = 1L;
            {
                this.put(BREAKDOWN_REPORT, "breakdown");
                this.put(BENCHMARK_REPORT, "benchmark");
                this.put(CHARTS_REPORT, "overview_chart");
                this.put(CONSOLIDATED_REPORT, "consolidated");
                this.put(COVERAGE_OVERVIEW, "coverage");
                this.put(CUSTOM_REPORT, "");
                this.put(DETAILED_REPORT, "detailed");
                this.put(FEATURE_MAP_REPORT, "feature_map");
                this.put(FEATURE_OVERVIEW, "feature_overview");
                this.put(KNOWN_ERRORS, "known_errors");
                this.put(RESULTS_OVERVIEW, "overview");
                this.put(RETROSPECTIVE_OVERVIEW, "retrospective");
                this.put(SPLIT_FEATURE, "split_feature");
                this.put(SYSTEM_INFO, "system_info");
                this.put(USAGE, "usage");
            }
        };
    }
}

