/*
 * Decompiled with CFR 0.152.
 */
package com.github.mkolisnyk.cucumber.reporting.utils.helpers;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeFieldType;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;

public final class StringConversionUtils {
    private StringConversionUtils() {
    }

    public static String transformPathString(String input) {
        String output = input;
        String datePattern = "DATE\\(([^)]+)\\)";
        String varPattern = "\\$\\{(.*)}";
        if (output == null) {
            return null;
        }
        while (output.matches("(.*)" + datePattern + "(.*)")) {
            String format = output.split("DATE\\(")[1].split("\\)")[0].trim();
            String value = DateTimeFormat.forPattern((String)format).withDefaultYear(new DateTime().get(DateTimeFieldType.yearOfEra())).withLocale(Locale.US).print((ReadableInstant)new DateTime());
            output = output.replaceFirst(datePattern, value);
        }
        while (output.matches("(.*)" + varPattern + "(.*)")) {
            String name = output.split("\\$\\{")[1].split("}")[0].trim();
            if (StringUtils.isNotBlank((CharSequence)System.getProperty(name))) {
                output = output.replaceFirst(varPattern, System.getProperty(name));
                continue;
            }
            output = output.replaceFirst(varPattern, System.getenv(name));
        }
        return output;
    }

    public static String replaceHtmlEntitiesWithCodes(String input) throws IOException {
        String output = input;
        HashMap<String, String> entitiesMap = new HashMap<String, String>();
        InputStream is = StringConversionUtils.class.getResourceAsStream("/html_entities_map.txt");
        String[] result = IOUtils.toString((InputStream)is).split("\n");
        is.close();
        for (String line : result) {
            entitiesMap.put(line.split("(\\s+)")[0], line.split("(\\s+)")[1]);
        }
        for (Map.Entry entry : entitiesMap.entrySet()) {
            output = output.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return output;
    }
}

