/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter;

import com.github.mygreen.cellformatter.ConditionFormatterFactory;
import com.github.mygreen.cellformatter.ConditionNumberFormatter;
import com.github.mygreen.cellformatter.LocaleSymbol;
import com.github.mygreen.cellformatter.lang.ArgUtils;
import com.github.mygreen.cellformatter.lang.Utils;
import com.github.mygreen.cellformatter.number.FormattedNumber;
import com.github.mygreen.cellformatter.number.NumberFactory;
import com.github.mygreen.cellformatter.number.NumberPartType;
import com.github.mygreen.cellformatter.term.AsteriskTerm;
import com.github.mygreen.cellformatter.term.EscapedCharTerm;
import com.github.mygreen.cellformatter.term.LocaelSymbolTerm;
import com.github.mygreen.cellformatter.term.NumberTerm;
import com.github.mygreen.cellformatter.term.OtherTerm;
import com.github.mygreen.cellformatter.term.Term;
import com.github.mygreen.cellformatter.term.UnderscoreTerm;
import com.github.mygreen.cellformatter.term.WordTerm;
import com.github.mygreen.cellformatter.tokenizer.Token;
import com.github.mygreen.cellformatter.tokenizer.TokenStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConditionNumberFormatterFactory
extends ConditionFormatterFactory<ConditionNumberFormatter> {
    private static final Logger logger = LoggerFactory.getLogger(ConditionNumberFormatterFactory.class);
    private static final String[] FORMAT_CHARS = new String[]{"#", "0", "?"};
    public static final String[] SYMBOL_CHARS = new String[]{".", ",", "%", "/"};
    public static final String[] OTHER_CHARS = new String[]{"E+", "E-", "General"};
    public static final String[] DIGITS_START_CHARS = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9"};
    public static final String[] DIGITS_CHARS = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "0"};
    private static final String[] NUMBER_DECISTION_CHARS = ConditionNumberFormatterFactory.toArray(FORMAT_CHARS, SYMBOL_CHARS);
    private static final String[] NUMBER_TERM_CHARS = ConditionNumberFormatterFactory.toArray(FORMAT_CHARS, SYMBOL_CHARS, OTHER_CHARS, DIGITS_START_CHARS);
    private static final List<String> SORTED_NUMBER_TERM_CHARS = Utils.reverse(NUMBER_TERM_CHARS);

    public boolean isNumberPattern(TokenStore store) {
        return store.containsAnyInFactor(NUMBER_DECISTION_CHARS);
    }

    @Override
    public ConditionNumberFormatter create(TokenStore store) {
        ArgUtils.notNull(store, "store");
        ConditionNumberFormatter formatter = new ConditionNumberFormatter(store.getConcatenatedToken());
        for (Token token : store.getTokens()) {
            if (token instanceof Token.Condition) {
                Token.Condition conditionToken = token.asCondition();
                String condition = conditionToken.getCondition();
                formatter.addCondition(condition);
                if (this.isConditionOperator(conditionToken)) {
                    this.setupConditionOperator(formatter, conditionToken);
                    continue;
                }
                if (this.isConditionLocale(conditionToken)) {
                    this.setupConditionLocale(formatter, conditionToken);
                    continue;
                }
                if (this.isConditionLocaleSymbol(conditionToken)) {
                    LocaleSymbol localeSymbol = this.setupConditionLocaleSymbol(formatter, conditionToken);
                    formatter.addTerm(new LocaelSymbolTerm<FormattedNumber>(localeSymbol));
                    continue;
                }
                if (this.isConditionDbNum(conditionToken)) {
                    this.setupConditionDbNum(formatter, conditionToken);
                    continue;
                }
                if (!this.isConditionColor(conditionToken)) continue;
                this.setupConditionColor(formatter, conditionToken);
                continue;
            }
            if (token instanceof Token.Word) {
                formatter.addTerm(new WordTerm<FormattedNumber>(token.asWord()));
                continue;
            }
            if (token instanceof Token.EscapedChar) {
                formatter.addTerm(new EscapedCharTerm<FormattedNumber>(token.asEscapedChar()));
                continue;
            }
            if (token instanceof Token.Underscore) {
                formatter.addTerm(new UnderscoreTerm<FormattedNumber>(token.asUnderscore()));
                continue;
            }
            if (token instanceof Token.Asterisk) {
                formatter.addTerm(new AsteriskTerm<FormattedNumber>(token.asAsterisk()));
                continue;
            }
            if (token instanceof Token.Factor) {
                List<Token> list = this.convertFactor(token.asFactor());
                for (Token item : list) {
                    if (item instanceof Token.Formatter) {
                        if (item.getValue().equals("#")) {
                            formatter.addTerm(NumberTerm.sharp());
                            continue;
                        }
                        if (item.getValue().equals("0")) {
                            formatter.addTerm(NumberTerm.zero());
                            continue;
                        }
                        if (item.getValue().equals("?")) {
                            formatter.addTerm(NumberTerm.question());
                            continue;
                        }
                        logger.warn("unknown formatter : '{}'", (Object)item.getValue());
                        continue;
                    }
                    if (item instanceof Token.Factor) {
                        if (Utils.startsWithIgnoreCase(item.getValue(), "E")) {
                            formatter.addTerm(NumberTerm.exponnet(item));
                            continue;
                        }
                        if (item.getValue().equals("General")) {
                            formatter.addTerm(NumberTerm.general());
                            continue;
                        }
                        formatter.addTerm(new OtherTerm<FormattedNumber>(item));
                        continue;
                    }
                    if (item instanceof Token.Symbol) {
                        if (item == Token.SYMBOL_COLON) {
                            formatter.addTerm(NumberTerm.separator(item.asSymbol()));
                            continue;
                        }
                        formatter.addTerm(NumberTerm.symbol(item.asSymbol()));
                        continue;
                    }
                    if (item instanceof Token.Digits) {
                        formatter.addTerm(NumberTerm.digits(item.asDigits()));
                        continue;
                    }
                    formatter.addTerm(new OtherTerm<FormattedNumber>(item));
                }
                continue;
            }
            formatter.addTerm(new OtherTerm<FormattedNumber>(token));
        }
        this.setupFormat(formatter);
        return formatter;
    }

    private List<Token> convertFactor(Token.Factor factor) {
        String item = factor.getValue();
        int itemLength = item.length();
        ArrayList<Token> list = new ArrayList<Token>();
        int idx = 0;
        StringBuilder noTermChar = new StringBuilder();
        while (idx < itemLength) {
            String matchChars = null;
            for (String chars : SORTED_NUMBER_TERM_CHARS) {
                if (!Utils.startsWithIgnoreCase(item, chars, idx)) continue;
                matchChars = item.substring(idx, idx + chars.length());
                break;
            }
            if (matchChars == null) {
                noTermChar.append(item.charAt(idx));
                ++idx;
                continue;
            }
            if (noTermChar.length() > 0) {
                list.add(Token.factor(noTermChar.toString()));
                noTermChar = new StringBuilder();
            }
            if (Utils.equalsAny(matchChars, DIGITS_START_CHARS)) {
                String str;
                StringBuilder digits = new StringBuilder();
                digits.append(matchChars);
                for (int i = idx + 1; i < itemLength && Utils.equalsAny(str = String.valueOf(item.charAt(i)), DIGITS_CHARS); ++i) {
                    digits.append(str);
                }
                list.add(Token.digits(digits.toString()));
                idx += digits.length();
                continue;
            }
            if (Utils.equalsAny(matchChars, FORMAT_CHARS)) {
                list.add(Token.formatter(matchChars));
            } else if (Utils.equalsAny(matchChars, SYMBOL_CHARS)) {
                if (matchChars.equals(".")) {
                    list.add(Token.SYMBOL_DOT);
                } else if (matchChars.equals(",")) {
                    list.add(Token.SYMBOL_COLON);
                } else if (matchChars.equals("%")) {
                    list.add(Token.SYMBOL_PERCENT);
                } else if (matchChars.equals("/")) {
                    list.add(Token.SYMBOL_SLASH);
                } else {
                    logger.warn("unknown symbol : '{}'", (Object)matchChars);
                }
            } else {
                list.add(Token.factor(matchChars));
            }
            idx += matchChars.length();
        }
        if (noTermChar.length() > 0) {
            list.add(Token.factor(noTermChar.toString()));
        }
        return list;
    }

    private void setupFormat(ConditionNumberFormatter formatter) {
        if (formatter.containsSymbolTerm(Token.SYMBOL_SLASH)) {
            this.setupFormatAsFraction(formatter);
        } else {
            this.setupFormatAsDecimal(formatter);
        }
    }

    private void setupFormatAsFraction(ConditionNumberFormatter formatter) {
        NumberTerm.FormattedTerm formattedTerm;
        Term<FormattedNumber> term;
        int i;
        int termSize = formatter.getTerms().size();
        int slashIndex = -1;
        for (int i2 = 0; i2 < termSize; ++i2) {
            Term<FormattedNumber> term2 = formatter.getTerms().get(i2);
            if (!ConditionNumberFormatterFactory.isSymbolTerm(term2, Token.SYMBOL_SLASH)) continue;
            slashIndex = i2;
            break;
        }
        boolean wholeType = false;
        if (slashIndex > 0) {
            NumberPartType partType = NumberPartType.Numerator;
            int countNumeratorTerm = 0;
            int countWholeNumberTerm = 0;
            boolean foundFirst = false;
            for (i = slashIndex - 1; i >= 0; --i) {
                term = formatter.getTerms().get(i);
                if (term instanceof NumberTerm.FormattedTerm) {
                    formattedTerm = (NumberTerm.FormattedTerm)term;
                    formattedTerm.setPart(partType);
                    if (partType.equals((Object)NumberPartType.Numerator)) {
                        formattedTerm.setIndex(++countNumeratorTerm);
                    } else if (partType.equals((Object)NumberPartType.WholeNumber)) {
                        formattedTerm.setIndex(++countWholeNumberTerm);
                    }
                    if (foundFirst) continue;
                    foundFirst = true;
                    continue;
                }
                if (!foundFirst) continue;
                partType = NumberPartType.WholeNumber;
            }
            if (countWholeNumberTerm > 0) {
                wholeType = true;
            }
        }
        boolean exactDenom = false;
        int denominator = -1;
        if (slashIndex < termSize) {
            int countDenominatorTerm = 0;
            int exactDenominator = -1;
            for (i = termSize - 1; i > slashIndex; --i) {
                term = formatter.getTerms().get(i);
                if (term instanceof NumberTerm.FormattedTerm) {
                    formattedTerm = (NumberTerm.FormattedTerm)term;
                    formattedTerm.setPart(NumberPartType.Denominator);
                    formattedTerm.setIndex(++countDenominatorTerm);
                    continue;
                }
                if (!(term instanceof NumberTerm.DigitsTerm)) continue;
                NumberTerm.DigitsTerm digitsTerm = (NumberTerm.DigitsTerm)term;
                exactDenominator = digitsTerm.getToken().intValue();
            }
            if (exactDenominator > 0) {
                denominator = exactDenominator;
                exactDenom = true;
            } else {
                denominator = countDenominatorTerm > 0 ? (countDenominatorTerm >= 5 ? (int)Math.pow(10.0, 5.0) : (int)Math.pow(10.0, countDenominatorTerm)) : 10;
            }
        }
        boolean foundFistWholeNumber = false;
        boolean foundFistNumerator = false;
        boolean foundFistDenominator = false;
        for (Term<FormattedNumber> term3 : formatter.getTerms()) {
            if (!(term3 instanceof NumberTerm.FormattedTerm)) continue;
            NumberTerm.FormattedTerm formattedTerm2 = (NumberTerm.FormattedTerm)term3;
            if (formattedTerm2.getPartType().equals((Object)NumberPartType.WholeNumber) && !foundFistWholeNumber) {
                formattedTerm2.setLastPart(true);
                foundFistWholeNumber = true;
                continue;
            }
            if (formattedTerm2.getPartType().equals((Object)NumberPartType.Numerator) && !foundFistNumerator) {
                formattedTerm2.setLastPart(true);
                foundFistNumerator = true;
                continue;
            }
            if (!formattedTerm2.getPartType().equals((Object)NumberPartType.Denominator) || foundFistDenominator) continue;
            formattedTerm2.setLastPart(true);
            foundFistDenominator = true;
        }
        formatter.setNumberFactory(NumberFactory.fractionNumber(denominator, exactDenom, wholeType));
    }

    private void setupFormatAsDecimal(ConditionNumberFormatter formatter) {
        NumberPartType partType = NumberPartType.Integer;
        boolean foundFirst = false;
        int countDecimalTerm = 0;
        boolean foundPercentTerm = false;
        for (Term<FormattedNumber> term : formatter.getTerms()) {
            if (ConditionNumberFormatterFactory.isSymbolTerm(term, Token.SYMBOL_PERCENT)) {
                foundPercentTerm = true;
                continue;
            }
            if (ConditionNumberFormatterFactory.isSymbolTerm(term, Token.SYMBOL_DOT)) {
                partType = NumberPartType.Decimal;
                foundFirst = false;
                continue;
            }
            if (term instanceof NumberTerm.ExponentTerm) {
                partType = NumberPartType.Exponent;
                foundFirst = false;
                continue;
            }
            if (!(term instanceof NumberTerm.FormattedTerm)) continue;
            NumberTerm.FormattedTerm formattedTerm = (NumberTerm.FormattedTerm)term;
            formattedTerm.setPart(partType);
            if (partType.equals((Object)NumberPartType.Decimal)) {
                formattedTerm.setIndex(++countDecimalTerm);
                continue;
            }
            if (foundFirst) continue;
            formattedTerm.setLastPart(true);
            foundFirst = true;
        }
        foundFirst = false;
        int countIntegerTerm = 0;
        int countExponentTerm = 0;
        int termSize = formatter.getTerms().size();
        for (int i = 0; i < termSize; ++i) {
            Term<FormattedNumber> term = formatter.getTerms().get(termSize - i - 1);
            if (!(term instanceof NumberTerm.FormattedTerm)) continue;
            NumberTerm.FormattedTerm formattedTerm = (NumberTerm.FormattedTerm)term;
            if (formattedTerm.getPartType().equals((Object)NumberPartType.Decimal)) {
                if (foundFirst) continue;
                formattedTerm.setLastPart(true);
                foundFirst = true;
                continue;
            }
            if (formattedTerm.getPartType().equals((Object)NumberPartType.Integer)) {
                formattedTerm.setIndex(++countIntegerTerm);
                continue;
            }
            if (!formattedTerm.getPartType().equals((Object)NumberPartType.Exponent)) continue;
            formattedTerm.setIndex(++countExponentTerm);
        }
        boolean useSeparator = false;
        boolean inIntegerPater = false;
        for (Term<FormattedNumber> term : formatter.getTerms()) {
            NumberTerm.FormattedTerm formattedTerm;
            if (term instanceof NumberTerm.FormattedTerm && (formattedTerm = (NumberTerm.FormattedTerm)term).getPartType().equals((Object)NumberPartType.Integer)) {
                if (formattedTerm.isLastPart() && formattedTerm.getIndex() > 1) {
                    inIntegerPater = true;
                } else if (formattedTerm.getIndex() <= 1) {
                    inIntegerPater = false;
                }
            }
            if (!(term instanceof NumberTerm.SeparatorTerm) || !inIntegerPater) continue;
            useSeparator = true;
        }
        int indexLastFormatterdTerm = -1;
        for (int i = 0; i < termSize; ++i) {
            Term<FormattedNumber> term = formatter.getTerms().get(termSize - i - 1);
            if (!(term instanceof NumberTerm.FormattedTerm)) continue;
            indexLastFormatterdTerm = termSize - i - 1;
            break;
        }
        int countLastColon = 0;
        if (indexLastFormatterdTerm >= 0 && indexLastFormatterdTerm + 1 < termSize) {
            Term<FormattedNumber> term;
            for (int i = indexLastFormatterdTerm + 1; i < termSize && (term = formatter.getTerms().get(i)) instanceof NumberTerm.SeparatorTerm; ++i) {
                ++countLastColon;
            }
        }
        if (countExponentTerm > 0) {
            formatter.setNumberFactory(NumberFactory.exponentNumber(countDecimalTerm, useSeparator));
        } else if (foundPercentTerm) {
            formatter.setNumberFactory(NumberFactory.percentNumber(countDecimalTerm, useSeparator, countLastColon));
        } else {
            boolean useDBNum = false;
            for (String condition : formatter.getConditions()) {
                if (!condition.startsWith("DBNum")) continue;
                useDBNum = true;
                break;
            }
            boolean generalFormat = false;
            for (Term<FormattedNumber> term : formatter.getTerms()) {
                if (!(term instanceof NumberTerm.GeneralTerm)) continue;
                generalFormat = true;
                break;
            }
            if (useDBNum && generalFormat) {
                formatter.setNumberFactory(NumberFactory.nativeNumber());
            } else {
                formatter.setNumberFactory(NumberFactory.decimalNumber(countDecimalTerm, useSeparator, countLastColon));
            }
        }
    }

    private static boolean isSymbolTerm(Term<FormattedNumber> term, Token.Symbol symbol) {
        if (!(term instanceof NumberTerm.SymbolTerm)) {
            return false;
        }
        NumberTerm.SymbolTerm symbolTerm = (NumberTerm.SymbolTerm)term;
        return symbolTerm.getToken().equals(symbol);
    }

    private static String[] toArray(String[] ... arrays) {
        ArrayList<String> list = new ArrayList<String>();
        for (String[] array : arrays) {
            list.addAll(Arrays.asList(array));
        }
        return list.toArray(new String[list.size()]);
    }
}

