/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter;

public abstract class ConditionOperator {
    public static ConditionOperator ALL = new ConditionOperator(){

        @Override
        public boolean isMatch(double value) {
            return true;
        }
    };
    public static ConditionOperator POSITIVE = new GreaterThan(0.0);
    public static ConditionOperator NEGATIVE = new LessThan(0.0);
    public static ConditionOperator ZERO = new Equal(0.0);
    public static ConditionOperator NON_NEGATIVE = new GreaterEqual(0.0);

    public abstract boolean isMatch(double var1);

    public static class LessEqual
    extends ConditionOperator {
        private final double condition;

        public LessEqual(double condition) {
            this.condition = condition;
        }

        @Override
        public boolean isMatch(double value) {
            return value <= this.condition;
        }

        public double getConditionValue() {
            return this.condition;
        }
    }

    public static class GreaterEqual
    extends ConditionOperator {
        private final double condition;

        public GreaterEqual(double condition) {
            this.condition = condition;
        }

        @Override
        public boolean isMatch(double value) {
            return value >= this.condition;
        }

        public double getConditionValue() {
            return this.condition;
        }
    }

    public static class LessThan
    extends ConditionOperator {
        private final double condition;

        public LessThan(double condition) {
            this.condition = condition;
        }

        @Override
        public boolean isMatch(double value) {
            return value < this.condition;
        }

        public double getConditionValue() {
            return this.condition;
        }
    }

    public static class GreaterThan
    extends ConditionOperator {
        private final double condition;

        public GreaterThan(double condition) {
            this.condition = condition;
        }

        @Override
        public boolean isMatch(double value) {
            return value > this.condition;
        }

        public double getConditionValue() {
            return this.condition;
        }
    }

    public static class NotEqual
    extends ConditionOperator {
        private final double condition;

        public NotEqual(double condition) {
            this.condition = condition;
        }

        @Override
        public boolean isMatch(double value) {
            return value != this.condition;
        }

        public double getConditionValue() {
            return this.condition;
        }
    }

    public static class Equal
    extends ConditionOperator {
        private final double condition;

        public Equal(double condition) {
            this.condition = condition;
        }

        @Override
        public boolean isMatch(double value) {
            return value == this.condition;
        }

        public double getConditionValue() {
            return this.condition;
        }
    }
}

