/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter;

import com.github.mygreen.cellformatter.ObjectCell;
import com.github.mygreen.cellformatter.lang.ExcelDateUtils;
import java.util.Date;
import java.util.TimeZone;

public class DateCell
extends ObjectCell<Date> {
    private final boolean dateStart1904;

    public DateCell(Date value, short formatIndex) {
        this(value, formatIndex, false);
    }

    public DateCell(Date value, String formatPattern) {
        this(value, formatPattern, false);
    }

    public DateCell(Date value, short formatIndex, String formatPattern) {
        this(value, formatIndex, formatPattern, false);
    }

    public DateCell(Date value, short formatIndex, boolean dateStart1904) {
        super(value, formatIndex);
        this.dateStart1904 = dateStart1904;
    }

    public DateCell(Date value, String formatPattern, boolean dateStart1904) {
        super(value, formatPattern);
        this.dateStart1904 = dateStart1904;
    }

    public DateCell(Date value, short formatIndex, String formatPattern, boolean dateStart1904) {
        super(value, formatIndex, formatPattern);
        this.dateStart1904 = dateStart1904;
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public Date getDateCellValue() {
        return new Date(((Date)this.getValue()).getTime() + (long)TimeZone.getDefault().getRawOffset());
    }

    @Override
    public double getNumberCellValue() {
        return ExcelDateUtils.convertExcelNumber((Date)this.getValue(), this.isDateStart1904());
    }

    @Override
    public boolean isDateStart1904() {
        return this.dateStart1904;
    }
}

