/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter;

import com.github.mygreen.cellformatter.CommonCell;
import com.github.mygreen.cellformatter.lang.ArgUtils;
import com.github.mygreen.cellformatter.lang.ExcelDateUtils;
import com.github.mygreen.cellformatter.lang.Utils;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import jxl.BooleanCell;
import jxl.Cell;
import jxl.CellReferenceHelper;
import jxl.CellType;
import jxl.DateCell;
import jxl.LabelCell;
import jxl.NumberCell;
import jxl.biff.DisplayFormat;
import jxl.biff.XFRecord;
import jxl.format.CellFormat;
import jxl.format.Format;

public class JXLCell
implements CommonCell {
    private final boolean dateStart1904;
    private static Map<Short, String> BUILT_IN_FORMATS = new ConcurrentHashMap<Short, String>();
    private final Cell cell;

    public JXLCell(Cell cell, boolean dateStart1904) {
        ArgUtils.notNull(cell, "cell");
        this.cell = cell;
        this.dateStart1904 = dateStart1904;
    }

    public Cell getCell() {
        return this.cell;
    }

    @Override
    public short getFormatIndex() {
        CellFormat cellStyle = this.cell.getCellFormat();
        if (cellStyle == null) {
            return 0;
        }
        short formatIndex = this.getFormatIndex(cellStyle);
        return formatIndex;
    }

    private short getFormatIndex(CellFormat cellStyle) {
        Format cellFormat = cellStyle.getFormat();
        if (cellFormat == null && cellStyle instanceof XFRecord) {
            XFRecord record = (XFRecord)cellStyle;
            return (short)record.formatIndex;
        }
        if (cellFormat == null) {
            return 0;
        }
        if (cellFormat instanceof DisplayFormat) {
            DisplayFormat displayFormat = (DisplayFormat)cellFormat;
            return (short)displayFormat.getFormatIndex();
        }
        return 0;
    }

    @Override
    public String getFormatPattern() {
        CellFormat cellStyle = this.cell.getCellFormat();
        if (cellStyle == null) {
            return "";
        }
        short formatIndex = this.getFormatIndex(cellStyle);
        if (BUILT_IN_FORMATS.containsKey(formatIndex)) {
            return BUILT_IN_FORMATS.get(formatIndex);
        }
        Format cellFormat = cellStyle.getFormat();
        if (cellFormat == null) {
            return "";
        }
        String formatPattern = cellFormat.getFormatString();
        if (Utils.isEmpty(formatPattern)) {
            return "";
        }
        return formatPattern;
    }

    @Override
    public boolean isText() {
        return this.cell.getType() == CellType.LABEL || this.cell.getType() == CellType.STRING_FORMULA;
    }

    @Override
    public String getTextCellValue() {
        CellType type = this.cell.getType();
        if (type == CellType.LABEL || type == CellType.STRING_FORMULA) {
            return ((LabelCell)this.cell).getString();
        }
        return this.cell.getContents();
    }

    @Override
    public boolean isBoolean() {
        return this.cell.getType() == CellType.BOOLEAN || this.cell.getType() == CellType.BOOLEAN_FORMULA;
    }

    @Override
    public boolean getBooleanCellValue() {
        CellType type = this.cell.getType();
        if (type == CellType.BOOLEAN || type == CellType.BOOLEAN_FORMULA) {
            return ((BooleanCell)this.cell).getValue();
        }
        return false;
    }

    @Override
    public boolean isNumber() {
        CellType type = this.cell.getType();
        return type == CellType.NUMBER || type == CellType.NUMBER_FORMULA || type == CellType.DATE || type == CellType.DATE_FORMULA;
    }

    @Override
    public double getNumberCellValue() {
        CellType type = this.cell.getType();
        if (type == CellType.NUMBER || type == CellType.NUMBER_FORMULA) {
            return ((NumberCell)this.cell).getValue();
        }
        if (type == CellType.DATE || type == CellType.DATE_FORMULA) {
            Date date = ((DateCell)this.cell).getDate();
            double num = ExcelDateUtils.convertExcelNumber(date, this.isDateStart1904());
            return num;
        }
        return 0.0;
    }

    @Override
    public Date getDateCellValue() {
        if (this.cell.getType() == CellType.DATE || this.cell.getType() == CellType.DATE_FORMULA) {
            Date date = ((DateCell)this.cell).getDate();
            return this.adjustDate(date);
        }
        if (this.cell.getType() == CellType.NUMBER || this.cell.getType() == CellType.NUMBER_FORMULA) {
            double num = this.getNumberCellValue();
            Date date = ExcelDateUtils.convertJavaDate(num, this.isDateStart1904());
            return date;
        }
        return new Date(ExcelDateUtils.getExcelZeroDateTime(this.isDateStart1904()));
    }

    private Date adjustDate(Date date) {
        if (!this.isDateStart1904() && date.getTime() < ExcelDateUtils.MILLISECONDS_19000101) {
            return new Date(date.getTime() + TimeUnit.DAYS.toMillis(1L));
        }
        return date;
    }

    @Override
    public boolean isDateStart1904() {
        return this.dateStart1904;
    }

    @Override
    public String getCellAddress() {
        return CellReferenceHelper.getCellReference((int)this.cell.getColumn(), (int)this.cell.getRow());
    }

    static {
        BUILT_IN_FORMATS.put((short)5, "$#,##0_);($#,##0)");
        BUILT_IN_FORMATS.put((short)6, "$#,##0_);[Red]($#,##0)");
        BUILT_IN_FORMATS.put((short)7, "$#,##0.00);($#,##0.00)");
        BUILT_IN_FORMATS.put((short)8, "$#,##0.00_);[Red]($#,##0.00)");
        BUILT_IN_FORMATS.put((short)14, "m/d/yy");
        BUILT_IN_FORMATS.put((short)37, "#,##0_);(#,##0)");
        BUILT_IN_FORMATS.put((short)38, "#,##0_);[Red](#,##0)");
        BUILT_IN_FORMATS.put((short)39, "#,##0.00_);(#,##0.00)");
        BUILT_IN_FORMATS.put((short)40, "#,##0.00_);[Red](#,##0.00)");
        BUILT_IN_FORMATS.put((short)41, "_(* #,##0_);_(* (#,##0);_(* \"-\"_);_(@_)");
        BUILT_IN_FORMATS.put((short)42, "_($* #,##0_);_($* (#,##0);_($* \"-\"_);_(@_)");
        BUILT_IN_FORMATS.put((short)43, "_(* #,##0.00_);_(* (#,##0.00);_(* \"-\"??_);_(@_)");
        BUILT_IN_FORMATS.put((short)44, "_($* #,##0.00_);_($* (#,##0.00);_($* \"-\"??_);_(@_)");
        BUILT_IN_FORMATS.put((short)46, "[h]:mm:ss");
    }
}

