/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter;

import com.github.mygreen.cellformatter.CellFormatResult;
import com.github.mygreen.cellformatter.CellFormatter;
import com.github.mygreen.cellformatter.FormatCellType;
import com.github.mygreen.cellformatter.FormatterResolver;
import com.github.mygreen.cellformatter.JXLCell;
import com.github.mygreen.cellformatter.lang.ArgUtils;
import java.util.Locale;
import jxl.Cell;
import jxl.CellType;
import jxl.ErrorCell;

public class JXLCellFormatter {
    private FormatterResolver formatterResolver = new FormatterResolver();
    private boolean cache = true;
    private boolean errorCellAsEmpty = false;

    public String formatAsString(Cell cell, boolean isStartDate1904) {
        return this.formatAsString(cell, Locale.getDefault(), isStartDate1904);
    }

    public String formatAsString(Cell cell, Locale locale, boolean isStartDate1904) {
        ArgUtils.notNull(cell, "cell");
        return this.format(cell, locale, isStartDate1904).getText();
    }

    public CellFormatResult format(Cell cell, boolean isStartDate1904) {
        ArgUtils.notNull(cell, "cell");
        return this.format(cell, Locale.getDefault(), isStartDate1904);
    }

    public CellFormatResult format(Cell cell, Locale locale, boolean isStartDate1904) {
        ArgUtils.notNull(cell, "cell");
        Locale runtimeLocale = locale != null ? locale : Locale.getDefault();
        CellType cellType = cell.getType();
        if (cellType == CellType.EMPTY) {
            CellFormatResult result = new CellFormatResult();
            result.setCellType(FormatCellType.Blank);
            result.setText("");
            return result;
        }
        if (cellType == CellType.LABEL || cellType == CellType.STRING_FORMULA) {
            return this.getCellValue(cell, runtimeLocale, isStartDate1904);
        }
        if (cellType == CellType.BOOLEAN || cellType == CellType.BOOLEAN_FORMULA) {
            return this.getCellValue(cell, runtimeLocale, isStartDate1904);
        }
        if (cellType == CellType.ERROR || cellType == CellType.FORMULA_ERROR) {
            return this.getErrorCellValue(cell, runtimeLocale, isStartDate1904);
        }
        if (cellType == CellType.DATE || cellType == CellType.DATE_FORMULA) {
            return this.getCellValue(cell, runtimeLocale, isStartDate1904);
        }
        if (cellType == CellType.NUMBER || cellType == CellType.NUMBER_FORMULA) {
            return this.getCellValue(cell, runtimeLocale, isStartDate1904);
        }
        CellFormatResult result = new CellFormatResult();
        result.setCellType(FormatCellType.Unknown);
        result.setText("");
        return result;
    }

    private CellFormatResult getErrorCellValue(Cell cell, Locale locale, boolean isStartDate1904) {
        CellFormatResult result = new CellFormatResult();
        result.setCellType(FormatCellType.Error);
        ErrorCell errorCell = (ErrorCell)cell;
        int errorCode = errorCell.getErrorCode();
        result.setValue(errorCode);
        if (this.isErrorCellAsEmpty()) {
            result.setText("");
        } else {
            switch (errorCode) {
                case 7: {
                    result.setText("#DIV/0!");
                    break;
                }
                case 42: {
                    result.setText("#N/A");
                    break;
                }
                case 29: {
                    result.setText("#NAME?");
                    break;
                }
                case 0: {
                    result.setText("#NULL!");
                    break;
                }
                case 36: {
                    result.setText("#NUM!");
                    break;
                }
                case 23: {
                    result.setText("#REF!");
                    break;
                }
                case 15: {
                    result.setText("#VALUE!");
                    break;
                }
                default: {
                    result.setText("");
                }
            }
        }
        return result;
    }

    private CellFormatResult getCellValue(Cell cell, Locale locale, boolean isStartDate1904) {
        JXLCell jxlCell = new JXLCell(cell, isStartDate1904);
        short formatIndex = jxlCell.getFormatIndex();
        String formatPattern = jxlCell.getFormatPattern();
        if (this.formatterResolver.canResolve(formatIndex)) {
            CellFormatter cellFormatter = this.formatterResolver.getFormatter(formatIndex);
            return cellFormatter.format(jxlCell, locale);
        }
        if (this.formatterResolver.canResolve(formatPattern)) {
            CellFormatter cellFormatter = this.formatterResolver.getFormatter(formatPattern);
            return cellFormatter.format(jxlCell, locale);
        }
        CellFormatter cellFormatter = this.formatterResolver.createFormatter(formatPattern);
        if (this.isCache()) {
            this.formatterResolver.registerFormatter(formatPattern, cellFormatter);
        }
        return cellFormatter.format(jxlCell, locale);
    }

    public FormatterResolver getFormatterResolver() {
        return this.formatterResolver;
    }

    public void setFormatterResolver(FormatterResolver formatterResolver) {
        this.formatterResolver = formatterResolver;
    }

    public boolean isCache() {
        return this.cache;
    }

    public void setCache(boolean cache) {
        this.cache = cache;
    }

    public boolean isErrorCellAsEmpty() {
        return this.errorCellAsEmpty;
    }

    public void setErrorCellAsEmpty(boolean errorCellAsEmpty) {
        this.errorCellAsEmpty = errorCellAsEmpty;
    }
}

