/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter;

import com.github.mygreen.cellformatter.CellFormatResult;
import com.github.mygreen.cellformatter.CellFormatter;
import com.github.mygreen.cellformatter.CommonCell;
import com.github.mygreen.cellformatter.lang.ArgUtils;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LocaleSwitchFormatter
extends CellFormatter {
    private final CellFormatter defaultFormatter;
    private final Map<Locale, CellFormatter> formatterMap = new ConcurrentHashMap<Locale, CellFormatter>();

    public LocaleSwitchFormatter(CellFormatter defaultFormatter) {
        ArgUtils.notNull(defaultFormatter, "defaultFormatter");
        this.defaultFormatter = defaultFormatter;
    }

    @Override
    public CellFormatResult format(CommonCell cell, Locale locale) {
        ArgUtils.notNull(cell, "cell");
        return this.getCellFormatter(locale).format(cell, locale);
    }

    private CellFormatter getCellFormatter(Locale locale) {
        if (locale == null) {
            return this.defaultFormatter;
        }
        if (this.formatterMap.containsKey(locale)) {
            return this.formatterMap.get(locale);
        }
        return this.defaultFormatter;
    }

    public LocaleSwitchFormatter register(CellFormatter cellFormatter, Locale ... locales) {
        ArgUtils.notNull(cellFormatter, "cellFormatter");
        ArgUtils.notEmpty(locales, "locales");
        for (Locale locale : locales) {
            this.formatterMap.put(locale, cellFormatter);
        }
        return this;
    }

    @Override
    public String getPattern(Locale locale) {
        return this.getCellFormatter(locale).getPattern();
    }
}

