/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter;

import com.github.mygreen.cellformatter.ObjectCell;
import com.github.mygreen.cellformatter.lang.ExcelDateUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class NumberCell<T extends Number>
extends ObjectCell<T> {
    private final boolean dateStart1904;
    private double number;

    public NumberCell(T value, short formatIndex) {
        this(value, formatIndex, false);
    }

    public NumberCell(T value, String formatPattern) {
        this(value, formatPattern, false);
    }

    public NumberCell(T value, short formatIndex, String formatPattern) {
        this(value, formatIndex, formatPattern, false);
    }

    public NumberCell(T value, short formatIndex, boolean dateStart1904) {
        super(value, formatIndex);
        this.number = this.toDouble(value);
        this.dateStart1904 = dateStart1904;
    }

    public NumberCell(T value, String formatPattern, boolean dateStart1904) {
        super(value, formatPattern);
        this.number = this.toDouble(value);
        this.dateStart1904 = dateStart1904;
    }

    public NumberCell(T value, short formatIndex, String formatPattern, boolean dateStart1904) {
        super(value, formatIndex, formatPattern);
        this.number = this.toDouble(value);
        this.dateStart1904 = dateStart1904;
    }

    private double toDouble(Object value) {
        Class<?> clazz = value.getClass();
        if (clazz.isPrimitive()) {
            if (clazz.equals(Byte.TYPE)) {
                return new BigDecimal(((Byte)value).byteValue()).doubleValue();
            }
            if (clazz.equals(Short.TYPE)) {
                return new BigDecimal(((Short)value).shortValue()).doubleValue();
            }
            if (clazz.equals(Integer.TYPE)) {
                return new BigDecimal((Integer)value).doubleValue();
            }
            if (clazz.equals(Long.TYPE)) {
                return new BigDecimal((Long)value).doubleValue();
            }
            if (clazz.equals(Float.TYPE)) {
                return new BigDecimal(((Float)value).floatValue()).doubleValue();
            }
            if (clazz.equals(Double.TYPE)) {
                return new BigDecimal((Double)value).doubleValue();
            }
        }
        if (value instanceof Byte) {
            return new BigDecimal(((Byte)value).byteValue()).doubleValue();
        }
        if (value instanceof Short) {
            return new BigDecimal(((Short)value).shortValue()).doubleValue();
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value).doubleValue();
        }
        if (value instanceof Long) {
            return new BigDecimal((Long)value).doubleValue();
        }
        if (value instanceof Float) {
            return new BigDecimal(((Float)value).floatValue()).doubleValue();
        }
        if (value instanceof Double) {
            return new BigDecimal((Double)value).doubleValue();
        }
        if (value instanceof AtomicInteger) {
            return new BigDecimal(((AtomicInteger)value).get()).doubleValue();
        }
        if (value instanceof AtomicLong) {
            return new BigDecimal(((AtomicLong)value).get()).doubleValue();
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).doubleValue();
        }
        if (value instanceof BigInteger) {
            return ((BigInteger)value).doubleValue();
        }
        throw new IllegalArgumentException("not support type class : " + clazz.getName());
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    @Override
    public double getNumberCellValue() {
        return this.number;
    }

    @Override
    public Date getDateCellValue() {
        return ExcelDateUtils.convertJavaDate(this.number, this.isDateStart1904());
    }

    @Override
    public boolean isDateStart1904() {
        return this.dateStart1904;
    }
}

