/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter;

import com.github.mygreen.cellformatter.CommonCell;
import com.github.mygreen.cellformatter.lang.ArgUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.TimeZone;
import org.apache.poi.hssf.model.InternalWorkbook;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class POICell
implements CommonCell {
    private static Logger logger = LoggerFactory.getLogger(POICell.class);
    private final Cell cell;

    public POICell(Cell cell) {
        ArgUtils.notNull(cell, "cell");
        this.cell = cell;
    }

    public Cell getCell() {
        return this.cell;
    }

    @Override
    public short getFormatIndex() {
        short formatIndex = this.getCell().getCellStyle().getDataFormat();
        return formatIndex;
    }

    @Override
    public String getFormatPattern() {
        short formatIndex;
        DataFormat dataFormat = this.cell.getSheet().getWorkbook().createDataFormat();
        String formatPattern = dataFormat.getFormat(formatIndex = this.getFormatIndex());
        if (formatPattern == null) {
            formatPattern = "";
        }
        return formatPattern;
    }

    @Override
    public boolean isText() {
        return this.cell.getCellTypeEnum() == CellType.STRING;
    }

    @Override
    public String getTextCellValue() {
        return this.cell.getStringCellValue();
    }

    @Override
    public boolean isBoolean() {
        return this.cell.getCellTypeEnum() == CellType.BOOLEAN;
    }

    @Override
    public boolean getBooleanCellValue() {
        return this.cell.getBooleanCellValue();
    }

    @Override
    public boolean isNumber() {
        return this.cell.getCellTypeEnum() == CellType.NUMERIC;
    }

    @Override
    public double getNumberCellValue() {
        return this.cell.getNumericCellValue();
    }

    @Override
    public Date getDateCellValue() {
        Date date = this.cell.getDateCellValue();
        return new Date(date.getTime() + (long)TimeZone.getDefault().getRawOffset());
    }

    @Override
    public boolean isDateStart1904() {
        Workbook workbook = this.cell.getSheet().getWorkbook();
        if (workbook instanceof HSSFWorkbook) {
            try {
                Method method = HSSFWorkbook.class.getDeclaredMethod("getWorkbook", new Class[0]);
                method.setAccessible(true);
                InternalWorkbook iw = (InternalWorkbook)method.invoke((Object)workbook, new Object[0]);
                return iw.isUsing1904DateWindowing();
            }
            catch (NoSuchMethodException | SecurityException e) {
                logger.warn("fail access method HSSFWorkbook.getWorkbook.", (Throwable)e);
                return false;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                logger.warn("fail invoke method HSSFWorkbook.getWorkbook.", (Throwable)e);
                return false;
            }
        }
        if (workbook instanceof XSSFWorkbook) {
            try {
                Method method = XSSFWorkbook.class.getDeclaredMethod("isDate1904", new Class[0]);
                method.setAccessible(true);
                boolean value = (Boolean)method.invoke((Object)workbook, new Object[0]);
                return value;
            }
            catch (NoSuchMethodException | SecurityException e) {
                logger.warn("fail access method XSSFWorkbook.isDate1904.", (Throwable)e);
                return false;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                logger.warn("fail invoke method XSSFWorkbook.isDate1904.", (Throwable)e);
                return false;
            }
        }
        logger.warn("unknown workbook type.", (Object)workbook.getClass().getName());
        return false;
    }

    @Override
    public String getCellAddress() {
        return CellReference.convertNumToColString((int)this.cell.getColumnIndex()) + String.valueOf(this.cell.getRowIndex() + 1);
    }
}

