/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter;

import com.github.mygreen.cellformatter.POICell;
import com.github.mygreen.cellformatter.lang.ExcelDateUtils;
import java.util.Date;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.CellValue;

public class POIEvaluatedCell
extends POICell {
    private final CellValue value;

    public POIEvaluatedCell(Cell cell, CellValue value) {
        super(cell);
        this.value = value;
    }

    public CellValue getCellValue() {
        return this.value;
    }

    @Override
    public boolean isText() {
        return this.value.getCellTypeEnum() == CellType.STRING;
    }

    @Override
    public String getTextCellValue() {
        return this.value.getStringValue();
    }

    @Override
    public boolean isBoolean() {
        return this.value.getCellTypeEnum() == CellType.BOOLEAN;
    }

    @Override
    public boolean getBooleanCellValue() {
        return this.value.getBooleanValue();
    }

    @Override
    public boolean isNumber() {
        return this.value.getCellTypeEnum() == CellType.NUMERIC;
    }

    @Override
    public double getNumberCellValue() {
        return this.value.getNumberValue();
    }

    @Override
    public Date getDateCellValue() {
        return ExcelDateUtils.convertJavaDate(this.getNumberCellValue(), this.isDateStart1904());
    }
}

