/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.callback;

import com.github.mygreen.cellformatter.callback.DBNumBase;
import com.github.mygreen.cellformatter.callback.KansujiConverter;
import com.github.mygreen.cellformatter.term.Term;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DBNum1
extends DBNumBase {
    private Map<String, KansujiConverter> converters = new ConcurrentHashMap<String, KansujiConverter>();

    public static DBNum1 create() {
        return new DBNum1();
    }

    public DBNum1() {
        super("ja", "zh", "ko");
        this.converters.put("ja", new KansujiConverter());
        this.converters.put("zh", new ChineseConverter());
        this.converters.put("ko", new KoreanConverter());
    }

    @Override
    public String call(Object data, String value, Locale locale, Term<?> term) {
        String language = locale.getLanguage().toLowerCase();
        return this.converters.get(language).convert(value, this.is4YearTerm(term));
    }

    public static class KoreanConverter
    extends KansujiConverter {
        public KoreanConverter() {
            this.setNumMap(new String[]{"\uff10", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\uf9d1", "\u4e03", "\u516b", "\u4e5d"});
        }

        @Override
        protected String replace4Digits(String value) {
            int length = value.length();
            ArrayList<String> digits = new ArrayList<String>();
            for (int i = 0; i < length; ++i) {
                char c = value.charAt(length - i - 1);
                if (c == '0') continue;
                String item = this.replaceSimple(String.valueOf(c)) + this.digits4Map[i];
                digits.add(item);
            }
            Collections.reverse(digits);
            StringBuilder sb = new StringBuilder();
            for (String item : digits) {
                sb.append(item);
            }
            return sb.toString();
        }
    }

    public static class ChineseConverter
    extends KansujiConverter {
        public ChineseConverter() {
            this.setNumMap(new String[]{"\u25cb", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"});
            this.setDigits10Map(new String[]{"", "\u4e07", "\u4ebf", "\u5146", "\u4eac"});
        }

        @Override
        protected String replace4Digits(String value) {
            int length = value.length();
            List<String> digits = new ArrayList<String>();
            for (int i = 0; i < length; ++i) {
                char c = value.charAt(length - i - 1);
                if (c == '0' && i == 0) continue;
                String item = c == '0' ? this.replaceSimple(String.valueOf(c)) : this.replaceSimple(String.valueOf(c)) + this.digits4Map[i];
                digits.add(item);
            }
            digits = this.removeZero(digits);
            Collections.reverse(digits);
            StringBuilder sb = new StringBuilder();
            for (String item : digits) {
                sb.append(item);
            }
            return sb.toString();
        }

        private List<String> removeZero(List<String> digits) {
            boolean foundNonZero = false;
            boolean beforeZero = false;
            ArrayList<String> list = new ArrayList<String>();
            for (String num : digits) {
                if (num.equals(this.numMap[0]) && !foundNonZero) continue;
                if (!num.equals(this.numMap[0])) {
                    foundNonZero = true;
                }
                if (num.equals(this.numMap[0])) {
                    if (!beforeZero) {
                        list.add(num);
                    }
                } else {
                    list.add(num);
                }
                beforeZero = num.equals(this.numMap[0]);
            }
            return list;
        }
    }
}

