/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.term;

import com.github.mygreen.cellformatter.lang.Era;
import com.github.mygreen.cellformatter.lang.EraPeriod;
import com.github.mygreen.cellformatter.lang.EraResolver;
import com.github.mygreen.cellformatter.lang.ExcelDateUtils;
import com.github.mygreen.cellformatter.lang.MSLocale;
import com.github.mygreen.cellformatter.lang.MessageResolver;
import com.github.mygreen.cellformatter.lang.Utils;
import com.github.mygreen.cellformatter.term.Term;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DateTerm
implements Term<Calendar> {
    protected static final Logger logger = LoggerFactory.getLogger(DateTerm.class);
    protected static final MessageResolver messageResolver = new MessageResolver("com.github.mygreen.cellformatter.label");
    protected static final EraResolver eraResolver = new EraResolver();

    @Override
    public String format(Calendar value, MSLocale formatLocale, Locale runtimeLocale) {
        return this.format(value, formatLocale, runtimeLocale, false);
    }

    public abstract String format(Calendar var1, MSLocale var2, Locale var3, boolean var4);

    private static long getElapsedZeroTime(Date date, boolean isStartDate1904) {
        if (isStartDate1904) {
            return ExcelDateUtils.getExcelZeroDateTime(isStartDate1904);
        }
        if (ExcelDateUtils.MILLISECONDS_19000301 <= date.getTime()) {
            return ExcelDateUtils.MILLISECONDS_19000101 - TimeUnit.DAYS.toMillis(2L);
        }
        return ExcelDateUtils.MILLISECONDS_19000101 - TimeUnit.DAYS.toMillis(1L);
    }

    public static DateTerm elapsedHour(String format) {
        return new ElapsedHourTerm(format);
    }

    public static DateTerm elapsedMinute(String format) {
        return new ElapsedMinuteTerm(format);
    }

    public static DateTerm elapsedSecond(String format) {
        return new ElapsedSecondTerm(format);
    }

    public static DateTerm year(String format) {
        return new YearTerm(format);
    }

    public static DateTerm eraName(String format) {
        return new EraNameTerm(format);
    }

    public static DateTerm eraYear(String format) {
        return new EraYearTerm(format);
    }

    public static DateTerm eraNameYear(String format) {
        return new EraNameYearTerm(format);
    }

    public static DateTerm month(String format) {
        return new MonthTerm(format);
    }

    public static DateTerm day(String format) {
        return new DayTerm(format);
    }

    public static DateTerm weekName(String format) {
        return new WeekName(format);
    }

    public static DateTerm weekNameForOO(String format) {
        return new WeekNameForOO(format);
    }

    public static DateTerm weekNumber(String format) {
        return new WeekNumberTerm(format);
    }

    public static DateTerm hour(String format, boolean half) {
        return new HourTerm(format, half);
    }

    public static DateTerm minute(String format) {
        return new MinuteTerm(format);
    }

    public static DateTerm second(String format) {
        return new SecondTerm(format);
    }

    public static DateTerm quater(String format) {
        return new QuaterTerm(format);
    }

    public static DateTerm amPm(String format) {
        return new AmPmTerm(format);
    }

    private static int getWeekIndex(Calendar cal) {
        int val = cal.get(7);
        switch (val) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
            case 6: {
                return 5;
            }
            case 7: {
                return 6;
            }
        }
        return 0;
    }

    public static class QuaterTerm
    extends DateTerm {
        private final String format;

        public QuaterTerm(String format) {
            this.format = format;
        }

        @Override
        public String format(Calendar cal, MSLocale formatLocale, Locale runtimeLocale, boolean isStartDate1904) {
            int index = cal.get(2) / 3 + 1;
            if (this.format.length() == 1) {
                String key = String.format("quaterTerm.%d.abbrev", index);
                return messageResolver.getMessage(formatLocale, runtimeLocale, key);
            }
            String key = String.format("quaterTerm.%d.name", index);
            return messageResolver.getMessage(formatLocale, runtimeLocale, key);
        }
    }

    public static class AmPmTerm
    extends DateTerm {
        private final String format;
        private final String am;
        private final String pm;

        public AmPmTerm(String format) {
            this.format = format;
            String[] split = format.split("/");
            if (split.length >= 2) {
                this.am = split[0];
                this.pm = split[1];
            } else {
                this.am = "AM";
                this.pm = "PM";
            }
        }

        @Override
        public String format(Calendar cal, MSLocale formatLocale, Locale runtimeLocale, boolean isStartDate1904) {
            int val = cal.get(9);
            if (val == 0) {
                return messageResolver.getMessage(formatLocale, "day.am.name", this.am);
            }
            return messageResolver.getMessage(formatLocale, "day.pm.name", this.pm);
        }

        public String getFormat() {
            return this.format;
        }

        public String getAm() {
            return this.am;
        }

        public String getPm() {
            return this.pm;
        }
    }

    public static class SecondTerm
    extends DateTerm {
        private final String format;

        public SecondTerm(String format) {
            this.format = format;
        }

        @Override
        public String format(Calendar cal, MSLocale formatLocale, Locale runtimeLocale, boolean isStartDate1904) {
            String value = String.valueOf(cal.get(13));
            int formatLength = this.format.length();
            return Utils.supplyZero(value, formatLength);
        }

        public String getFormat() {
            return this.format;
        }
    }

    public static class MinuteTerm
    extends DateTerm {
        private final String format;

        public MinuteTerm(String format) {
            this.format = format;
        }

        @Override
        public String format(Calendar cal, MSLocale formatLocale, Locale runtimeLocale, boolean isStartDate1904) {
            String value = String.valueOf(cal.get(12));
            int formatLength = this.format.length();
            return Utils.supplyZero(value, formatLength);
        }

        public String getFormat() {
            return this.format;
        }
    }

    public static class HourTerm
    extends DateTerm {
        private final String format;
        private final boolean half;

        public HourTerm(String format, boolean half) {
            this.format = format;
            this.half = half;
        }

        @Override
        public String format(Calendar cal, MSLocale formatLocale, Locale runtimeLocale, boolean isStartDate1904) {
            String value = this.isHalf() ? String.valueOf(cal.get(10)) : String.valueOf(cal.get(11));
            int formatLength = this.format.length();
            return Utils.supplyZero(value, formatLength);
        }

        public boolean isHalf() {
            return this.half;
        }

        public String getFormat() {
            return this.format;
        }
    }

    public static class WeekNumberTerm
    extends DateTerm {
        private final String format;

        public WeekNumberTerm(String format) {
            this.format = format;
        }

        @Override
        public String format(Calendar cal, MSLocale formatLocale, Locale runtimeLocale, boolean isStartDate1904) {
            int val = cal.get(3);
            return String.valueOf(val);
        }

        public String getFormat() {
            return this.format;
        }
    }

    public static class WeekNameForOO
    extends DateTerm {
        private final String format;

        public WeekNameForOO(String format) {
            this.format = format;
        }

        @Override
        public String format(Calendar cal, MSLocale formatLocale, Locale runtimeLocale, boolean isStartDate1904) {
            int index = DateTerm.getWeekIndex(cal);
            int formatLength = this.format.length();
            if (formatLength <= 2) {
                String key = String.format("week.%d.abbrev", index);
                return messageResolver.getMessage(formatLocale, runtimeLocale, key);
            }
            String key = String.format("week.%d.name", index);
            return messageResolver.getMessage(formatLocale, runtimeLocale, key);
        }

        public String getFormat() {
            return this.format;
        }
    }

    public static class WeekName
    extends DateTerm {
        private final String format;

        public WeekName(String format) {
            this.format = format;
        }

        @Override
        public String format(Calendar cal, MSLocale formatLocale, Locale runtimeLocale, boolean isStartDate1904) {
            int index = DateTerm.getWeekIndex(cal);
            int formatLength = this.format.length();
            if (formatLength <= 3) {
                String key = String.format("week.%d.abbrev", index);
                return messageResolver.getMessage(formatLocale, runtimeLocale, key);
            }
            String key = String.format("week.%d.name", index);
            return messageResolver.getMessage(formatLocale, runtimeLocale, key);
        }

        public String getFormat() {
            return this.format;
        }
    }

    public static class DayTerm
    extends DateTerm {
        private final String format;

        public DayTerm(String format) {
            this.format = format;
        }

        @Override
        public String format(Calendar cal, MSLocale formatLocale, Locale runtimeLocale, boolean isStartDate1904) {
            int value = cal.get(5);
            int formatLength = this.format.length();
            if (formatLength == 1) {
                return String.valueOf(value);
            }
            if (formatLength == 2) {
                return Utils.supplyZero(String.valueOf(value), 2);
            }
            if (formatLength == 3) {
                int index = DateTerm.getWeekIndex(cal);
                String key = String.format("week.%d.abbrev", index);
                return messageResolver.getMessage(formatLocale, key);
            }
            if (formatLength >= 4) {
                int index = DateTerm.getWeekIndex(cal);
                String key = String.format("week.%d.name", index);
                return messageResolver.getMessage(formatLocale, key);
            }
            return Utils.supplyZero(String.valueOf(value), 2);
        }

        public String getFormat() {
            return this.format;
        }
    }

    public static class MonthTerm
    extends DateTerm {
        private final String format;

        public MonthTerm(String format) {
            this.format = format;
        }

        @Override
        public String format(Calendar cal, MSLocale formatLocale, Locale runtimeLocale, boolean isStartDate1904) {
            int value = cal.get(2) + 1;
            int formatLength = this.format.length();
            if (formatLength == 1) {
                return String.valueOf(value);
            }
            if (formatLength == 2) {
                return Utils.supplyZero(String.valueOf(value), 2);
            }
            if (formatLength == 3) {
                String key = String.format("month.%d.abbrev", value);
                return messageResolver.getMessage(formatLocale, key);
            }
            if (formatLength == 4) {
                String key = String.format("month.%d.name", value);
                return messageResolver.getMessage(formatLocale, key);
            }
            if (formatLength == 5) {
                String key = String.format("month.%d.leading", value);
                return messageResolver.getMessage(formatLocale, key);
            }
            return Utils.supplyZero(String.valueOf(value), 2);
        }

        public String getFormat() {
            return this.format;
        }
    }

    public static class EraNameYearTerm
    extends DateTerm {
        private final String format;

        public EraNameYearTerm(String format) {
            this.format = format;
        }

        @Override
        public String format(Calendar cal, MSLocale formatLocale, Locale runtimeLocale, boolean isStartDate1904) {
            int formatLength = this.format.length();
            Date date = cal.getTime();
            Era era = formatLocale != null ? eraResolver.getEra(formatLocale) : eraResolver.getEra(runtimeLocale);
            if (era.isUnkndown()) {
                String value = String.valueOf(cal.get(1));
                return Utils.supplyZero(value, formatLength);
            }
            EraPeriod period = era.getTargetPeriod(date);
            if (period.isUnknown()) {
                String value = String.valueOf(cal.get(1));
                return Utils.supplyZero(value, formatLength);
            }
            StringBuilder sb = new StringBuilder();
            if (formatLength >= 2) {
                sb.append(period.getName());
            }
            String strYear = String.valueOf(period.getEraYear(cal));
            sb.append(Utils.supplyZero(strYear, 2));
            return sb.toString();
        }

        public String getFormat() {
            return this.format;
        }
    }

    public static class EraYearTerm
    extends DateTerm {
        private final String format;

        public EraYearTerm(String format) {
            this.format = format;
        }

        @Override
        public String format(Calendar cal, MSLocale formatLocale, Locale runtimeLocale, boolean isStartDate1904) {
            int formatLength = this.format.length();
            Date date = cal.getTime();
            Era era = formatLocale != null ? eraResolver.getEra(formatLocale) : eraResolver.getEra(runtimeLocale);
            if (era.isUnkndown()) {
                String value = String.valueOf(cal.get(1));
                return Utils.supplyZero(value, formatLength);
            }
            EraPeriod period = era.getTargetPeriod(date);
            if (period.isUnknown()) {
                String value = String.valueOf(cal.get(1));
                return Utils.supplyZero(value, formatLength);
            }
            String value = String.valueOf(period.getEraYear(cal));
            return Utils.supplyZero(value, formatLength);
        }

        public String getFormat() {
            return this.format;
        }
    }

    public static class EraNameTerm
    extends DateTerm {
        private final String format;

        public EraNameTerm(String format) {
            this.format = format;
        }

        @Override
        public String format(Calendar cal, MSLocale formatLocale, Locale runtimeLocale, boolean isStartDate1904) {
            Date date = cal.getTime();
            Era era = formatLocale != null ? eraResolver.getEra(formatLocale) : eraResolver.getEra(runtimeLocale);
            if (era.isUnkndown()) {
                return "";
            }
            EraPeriod period = era.getTargetPeriod(date);
            if (period.isUnknown()) {
                return "";
            }
            int formatLength = this.format.length();
            if (formatLength == 1) {
                return period.getAbbrevRomanName();
            }
            if (formatLength == 2) {
                return period.getAbbrevName();
            }
            return period.getName();
        }

        public String getFormat() {
            return this.format;
        }
    }

    public static class YearTerm
    extends DateTerm {
        private final String format;

        public YearTerm(String format) {
            this.format = format;
        }

        @Override
        public String format(Calendar cal, MSLocale formatLocale, Locale runtimeLocale, boolean isStartDate1904) {
            String value = String.valueOf(cal.get(1));
            int formatLength = this.format.length();
            if (formatLength <= 2) {
                return Utils.supplyZero(value, 2).substring(2);
            }
            return Utils.supplyZero(value, 4);
        }

        public String getFormat() {
            return this.format;
        }
    }

    public static class ElapsedSecondTerm
    extends DateTerm {
        private static final long BASE = 1000L;
        private final String format;

        public ElapsedSecondTerm(String format) {
            this.format = format;
        }

        @Override
        public String format(Calendar cal, MSLocale formatLocale, Locale runtimeLocale, boolean isStartDate1904) {
            long zeroTime = DateTerm.getElapsedZeroTime(cal.getTime(), isStartDate1904);
            if (logger.isInfoEnabled()) {
                logger.info("ElapsedSecond:calendar={}, zeroTime={}.", (Object)ExcelDateUtils.formatDate(cal.getTime()), (Object)ExcelDateUtils.formatDate(new Date(zeroTime)));
            }
            long time = (cal.getTime().getTime() - zeroTime) / 1000L;
            int formatLength = this.format.length();
            return Utils.supplyZero(String.valueOf(time), formatLength);
        }

        public String getFormat() {
            return this.format;
        }
    }

    public static class ElapsedMinuteTerm
    extends DateTerm {
        private static final long BASE = 60000L;
        private final String format;

        public ElapsedMinuteTerm(String format) {
            this.format = format;
        }

        @Override
        public String format(Calendar cal, MSLocale formatLocale, Locale runtimeLocale, boolean isStartDate1904) {
            long zeroTime = DateTerm.getElapsedZeroTime(cal.getTime(), isStartDate1904);
            if (logger.isInfoEnabled()) {
                logger.info("ElapsedMinute:calendar={}, zeroTime={}.", (Object)ExcelDateUtils.formatDate(cal.getTime()), (Object)ExcelDateUtils.formatDate(new Date(zeroTime)));
            }
            long time = (cal.getTime().getTime() - zeroTime) / 60000L;
            int formatLength = this.format.length();
            return Utils.supplyZero(String.valueOf(time), formatLength);
        }

        public String getFormat() {
            return this.format;
        }
    }

    public static class ElapsedHourTerm
    extends DateTerm {
        private static final long BASE = 3600000L;
        private final String format;

        public ElapsedHourTerm(String format) {
            this.format = format;
        }

        @Override
        public String format(Calendar cal, MSLocale formatLocale, Locale runtimeLocale, boolean isStartDate1904) {
            long zeroTime = DateTerm.getElapsedZeroTime(cal.getTime(), isStartDate1904);
            if (logger.isInfoEnabled()) {
                logger.info("ElapsedHour:calendar={}, zeroTime={}.", (Object)ExcelDateUtils.formatDate(cal.getTime()), (Object)ExcelDateUtils.formatDate(new Date(zeroTime)));
            }
            long time = (cal.getTime().getTime() - zeroTime) / 3600000L;
            int formatLength = this.format.length();
            return Utils.supplyZero(String.valueOf(time), formatLength);
        }

        public String getFormat() {
            return this.format;
        }
    }
}

