/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.term;

import com.github.mygreen.cellformatter.lang.MSLocale;
import com.github.mygreen.cellformatter.lang.Utils;
import com.github.mygreen.cellformatter.number.FormattedNumber;
import com.github.mygreen.cellformatter.number.NativeNumber;
import com.github.mygreen.cellformatter.number.NumberPartType;
import com.github.mygreen.cellformatter.term.Term;
import com.github.mygreen.cellformatter.tokenizer.Token;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.Locale;

public abstract class NumberTerm
implements Term<FormattedNumber> {
    public static GeneralTerm general() {
        return new GeneralTerm();
    }

    public static ZeroTerm zero() {
        return new ZeroTerm();
    }

    public static SharpTerm sharp() {
        return new SharpTerm();
    }

    public static QuestionTerm question() {
        return new QuestionTerm();
    }

    public static ExponentTerm exponnet(Token token) {
        return new ExponentTerm(token);
    }

    public static SeparatorTerm separator(Token.Symbol token) {
        return new SeparatorTerm(token);
    }

    public static SymbolTerm symbol(Token.Symbol token) {
        return new SymbolTerm(token);
    }

    public static DigitsTerm digits(Token.Digits token) {
        return new DigitsTerm(token);
    }

    public static class DigitsTerm
    extends NumberTerm {
        private final Token.Digits token;

        public DigitsTerm(Token.Digits token) {
            this.token = token;
        }

        @Override
        public String format(FormattedNumber value, MSLocale formatLocale, Locale runtimeLocale) {
            return this.token.getValue();
        }

        public Token.Digits getToken() {
            return this.token;
        }
    }

    public static class SymbolTerm
    extends NumberTerm {
        private final Token.Symbol token;

        public SymbolTerm(Token.Symbol token) {
            this.token = token;
        }

        @Override
        public String format(FormattedNumber value, MSLocale formatLocale, Locale runtimeLocale) {
            return this.token.getValue();
        }

        public Token.Symbol getToken() {
            return this.token;
        }
    }

    public static class SeparatorTerm
    extends NumberTerm {
        private final Token.Symbol token;

        public SeparatorTerm(Token.Symbol token) {
            this.token = token;
        }

        @Override
        public String format(FormattedNumber value, MSLocale formatLocale, Locale runtimeLocale) {
            return "";
        }

        public Token.Symbol getToken() {
            return this.token;
        }
    }

    public static class ExponentTerm
    extends NumberTerm {
        private final Token token;
        private final String exponentSymbol;

        public ExponentTerm(Token token) {
            this.token = token;
            String vale = token.getValue();
            this.exponentSymbol = vale.startsWith("E") ? "E" : "e";
        }

        @Override
        public String format(FormattedNumber number, MSLocale formatLocale, Locale runtimeLocale) {
            if (number.asExponent().isExponentPositive()) {
                if (Utils.startsWithIgnoreCase(this.getToken().getValue(), "E-")) {
                    return this.exponentSymbol;
                }
                return this.exponentSymbol + "+";
            }
            return this.exponentSymbol + "-";
        }

        public Token getToken() {
            return this.token;
        }

        public String getExponentSymbol() {
            return this.exponentSymbol;
        }
    }

    public static class QuestionTerm
    extends FormattedTerm {
        private static final String SPACE = " ";

        @Override
        public String format(FormattedNumber number, MSLocale formatLocale, Locale runtimeLocale) {
            String num = this.getNumber(number);
            if (num.isEmpty()) {
                return SPACE;
            }
            return num;
        }
    }

    public static class SharpTerm
    extends FormattedTerm {
        @Override
        public String format(FormattedNumber number, MSLocale formatLocale, Locale runtimeLocale) {
            String num = this.getNumber(number);
            return num;
        }
    }

    public static class ZeroTerm
    extends FormattedTerm {
        private static final String ZERO = "0";

        @Override
        public String format(FormattedNumber number, MSLocale formatLocale, Locale runtimeLocale) {
            String num = this.getNumber(number);
            if (num.isEmpty()) {
                return ZERO;
            }
            return num;
        }
    }

    public static abstract class FormattedTerm
    extends NumberTerm {
        protected int index;
        protected NumberPartType partType;
        protected boolean lastPart;
        protected boolean outSepearator;

        public FormattedTerm index(int index) {
            this.index = index;
            return this;
        }

        public FormattedTerm partType(NumberPartType partType) {
            this.partType = partType;
            return this;
        }

        public FormattedTerm lastPart(boolean lastPart) {
            this.lastPart = lastPart;
            return this;
        }

        protected String getNumber(FormattedNumber number) {
            switch (this.partType) {
                case Integer: {
                    if (this.isLastPart()) {
                        return number.asDecimal().getIntegerPartAfter(this.getIndex());
                    }
                    return number.asDecimal().getIntegerPart(this.getIndex());
                }
                case Decimal: {
                    return number.asDecimal().getDecimalPart(this.getIndex());
                }
                case Exponent: {
                    if (this.isLastPart()) {
                        return number.asExponent().getExponentPartAfter(this.getIndex());
                    }
                    return number.asExponent().getExponentPart(this.getIndex());
                }
                case Denominator: {
                    if (this.isLastPart()) {
                        return number.asFraction().getDenominatorPartAfter(this.getIndex());
                    }
                    return number.asFraction().getDenominatorPart(this.getIndex());
                }
                case Numerator: {
                    if (this.isLastPart()) {
                        return number.asFraction().getNumeratorPartAfter(this.getIndex());
                    }
                    return number.asFraction().getNumeratorPart(this.getIndex());
                }
                case WholeNumber: {
                    if (this.isLastPart()) {
                        return number.asFraction().getWholeNumberPartAfter(this.getIndex());
                    }
                    return number.asFraction().getWholeNumberPart(this.getIndex());
                }
            }
            return "";
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public NumberPartType getPartType() {
            return this.partType;
        }

        public void setPart(NumberPartType partType) {
            this.partType = partType;
        }

        public boolean isLastPart() {
            return this.lastPart;
        }

        public void setLastPart(boolean lastPart) {
            this.lastPart = lastPart;
        }

        public boolean isOutSepearator() {
            return this.outSepearator;
        }

        public void setOutSepearator(boolean outSepearator) {
            this.outSepearator = outSepearator;
        }
    }

    public static class GeneralTerm
    extends NumberTerm {
        @Override
        public String format(FormattedNumber number, MSLocale formatLocale, Locale runtimeLocale) {
            String pattern;
            double unsingedValue = Math.abs(number.getValue());
            if (number instanceof NativeNumber) {
                return new BigDecimal(unsingedValue).toPlainString();
            }
            if (this.isNumberAsExponent(unsingedValue)) {
                DecimalFormat format = new DecimalFormat("0.#####E0");
                format.setRoundingMode(RoundingMode.HALF_UP);
                String str = format.format(unsingedValue);
                if (unsingedValue >= 1.0) {
                    str = str.replace("E", "E+");
                }
                return str;
            }
            BigDecimal num = new BigDecimal(unsingedValue);
            String strNum = num.toPlainString();
            if (!strNum.contains(".")) {
                return strNum;
            }
            String strIntPart = strNum.substring(0, strNum.indexOf("."));
            int intLength = strIntPart.length();
            if (intLength < 10) {
                StringBuilder f = new StringBuilder();
                f.append("0.");
                for (int i = 0; i < 10 - intLength; ++i) {
                    f.append("#");
                }
                pattern = f.toString();
            } else {
                pattern = "0";
            }
            DecimalFormat format = new DecimalFormat(pattern);
            format.setRoundingMode(RoundingMode.HALF_UP);
            return format.format(unsingedValue);
        }

        private boolean isNumberAsExponent(double unsingedValue) {
            if (unsingedValue == 0.0) {
                return false;
            }
            if (unsingedValue >= 1.0E11) {
                return true;
            }
            return unsingedValue <= 1.0E-10;
        }
    }
}

