/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.tokenizer;

import com.github.mygreen.cellformatter.lang.Utils;
import com.github.mygreen.cellformatter.tokenizer.StackUtils;
import com.github.mygreen.cellformatter.tokenizer.Token;
import com.github.mygreen.cellformatter.tokenizer.TokenStore;
import java.util.LinkedList;

public class CustomFormatTokenizer {
    public TokenStore parse(String pattern) {
        TokenStore store = new TokenStore();
        if (Utils.isEmpty(pattern)) {
            return store;
        }
        this.splitToken(store, pattern);
        return store;
    }

    private void splitToken(TokenStore store, String pattern) {
        LinkedList<String> stack = new LinkedList<String>();
        int length = pattern.length();
        for (int i = 0; i < length; ++i) {
            char c3;
            StringBuilder next;
            char c = pattern.charAt(i);
            if (StackUtils.equalsAnyTopElement(stack, Token.STR_ESCAPES)) {
                if (c == '\"' && StackUtils.equalsBottomElement(stack, "\"")) {
                    store.add(Token.word(StackUtils.popupAndConcat(stack) + c));
                    continue;
                }
                if (StackUtils.equalsAnyBottomElement(stack, new String[]{"[", "\""})) {
                    stack.push(String.valueOf(c));
                    continue;
                }
                String escapedChar = StackUtils.popup(stack);
                String concatStr = StackUtils.popupAndConcat(stack);
                if (concatStr.length() >= 1) {
                    store.add(Token.factor(concatStr));
                }
                store.add(Token.escapedChar(escapedChar + c));
                continue;
            }
            if (c == '\"') {
                if (StackUtils.equalsBottomElement(stack, "\"")) {
                    store.add(Token.word(StackUtils.popupAndConcat(stack) + c));
                    continue;
                }
                if (!stack.isEmpty()) {
                    store.add(Token.factor(StackUtils.popupAndConcat(stack)));
                    stack.push(String.valueOf(c));
                    continue;
                }
                stack.push(String.valueOf(c));
                continue;
            }
            if (c == '[') {
                if (!stack.isEmpty() && !StackUtils.equalsBottomElement(stack, "\"")) {
                    store.add(Token.factor(StackUtils.popupAndConcat(stack)));
                }
                stack.push(String.valueOf(c));
                continue;
            }
            if (c == ']') {
                if (StackUtils.equalsBottomElement(stack, "[")) {
                    store.add(Token.condition(StackUtils.popupAndConcat(stack) + c));
                    continue;
                }
                stack.push(String.valueOf(c));
                continue;
            }
            if (c == ';') {
                if (!stack.isEmpty()) {
                    store.add(Token.factor(StackUtils.popupAndConcat(stack)));
                }
                store.add(Token.SYMBOL_SEMI_COLON);
                continue;
            }
            if (c == '_') {
                if (StackUtils.equalsBottomElement(stack, "\"")) {
                    stack.push(String.valueOf(c));
                    continue;
                }
                if (!stack.isEmpty()) {
                    store.add(Token.factor(StackUtils.popupAndConcat(stack)));
                }
                next = new StringBuilder();
                if (i + 1 < length) {
                    char c2 = pattern.charAt(++i);
                    next.append(c2);
                    if (c2 == '\\' && i + 1 < length) {
                        ++i;
                        c3 = pattern.charAt(++i);
                        next.append(c3);
                    }
                    store.add(Token.underscore(c + next.toString()));
                    continue;
                }
                store.add(Token.factor(String.valueOf(c)));
                continue;
            }
            if (c == '*') {
                if (StackUtils.equalsBottomElement(stack, "\"")) {
                    stack.push(String.valueOf(c));
                    continue;
                }
                if (!stack.isEmpty()) {
                    store.add(Token.factor(StackUtils.popupAndConcat(stack)));
                }
                next = new StringBuilder();
                if (i + 1 < length) {
                    char c2 = pattern.charAt(++i);
                    next.append(c2);
                    if (c2 == '\\' && i + 1 < length) {
                        ++i;
                        c3 = pattern.charAt(++i);
                        next.append(c3);
                    }
                    store.add(Token.asterisk(c + next.toString()));
                    continue;
                }
                store.add(Token.factor(String.valueOf(c)));
                continue;
            }
            stack.push(String.valueOf(c));
        }
        if (!stack.isEmpty()) {
            store.add(Token.factor(StackUtils.popupAndConcat(stack)));
        }
    }
}

