/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.tokenizer;

public abstract class Token {
    public static final Symbol SYMBOL_SEMI_COLON = new Symbol(";");
    public static final Symbol SYMBOL_COLON = new Symbol(",");
    public static final Symbol SYMBOL_PERCENT = new Symbol("%");
    public static final Symbol SYMBOL_SLASH = new Symbol("/");
    public static final Symbol SYMBOL_DOT = new Symbol(".");
    public static final Symbol SYMBOL_AT_MARK = new Symbol("@");
    public static final String STR_ESCAPE_BACKSPACE = "\\";
    public static final String STR_ESCAPE_QUESTION = "!";
    public static final String[] STR_ESCAPES = new String[]{"\\", "!"};
    private final String value;

    public Token(String value) {
        this.value = value;
    }

    public static Word word(String token) {
        return new Word(token);
    }

    public static EscapedChar escapedChar(String token) {
        return new EscapedChar(token);
    }

    public static Condition condition(String token) {
        return new Condition(token);
    }

    public static Underscore underscore(String token) {
        return new Underscore(token);
    }

    public static Asterisk asterisk(String token) {
        return new Asterisk(token);
    }

    public static Factor factor(String token) {
        return new Factor(token);
    }

    public static Formatter formatter(String token) {
        return new Formatter(token);
    }

    public static Digits digits(String token) {
        return new Digits(token);
    }

    public Word asWord() {
        return (Word)this;
    }

    public Symbol asSymbol() {
        return (Symbol)this;
    }

    public EscapedChar asEscapedChar() {
        return (EscapedChar)this;
    }

    public Condition asCondition() {
        return (Condition)this;
    }

    public Underscore asUnderscore() {
        return (Underscore)this;
    }

    public Asterisk asAsterisk() {
        return (Asterisk)this;
    }

    public Factor asFactor() {
        return (Factor)this;
    }

    public Formatter asFormatter() {
        return (Formatter)this;
    }

    public Digits asDigits() {
        return (Digits)this;
    }

    public String toString() {
        return this.getValue();
    }

    public String getValue() {
        return this.value;
    }

    public static class Digits
    extends Token {
        public Digits(String value) {
            super(value);
        }

        public int intValue() {
            return Integer.valueOf(this.getValue());
        }
    }

    public static class Formatter
    extends Token {
        public Formatter(String value) {
            super(value);
        }
    }

    public static class Factor
    extends Token {
        public Factor(String value) {
            super(value);
        }
    }

    public static class Asterisk
    extends Token {
        public Asterisk(String value) {
            super(value);
        }

        public String getAttachedValue() {
            return this.getValue().substring(1);
        }
    }

    public static class Underscore
    extends Token {
        public Underscore(String value) {
            super(value);
        }

        public String getAttachedValue() {
            return this.getValue().substring(1);
        }
    }

    public static class Condition
    extends Token {
        public Condition(String value) {
            super(value);
        }

        public String getCondition() {
            int length = this.getValue().length();
            return this.getValue().substring(1, length - 1);
        }
    }

    public static class EscapedChar
    extends Token {
        public EscapedChar(String value) {
            super(value);
        }

        public String getChar() {
            return this.getValue().substring(1);
        }
    }

    public static class Symbol
    extends Token {
        public Symbol(String value) {
            super(value);
        }
    }

    public static class Word
    extends Token {
        public Word(String value) {
            super(value);
        }

        public String getWord() {
            int length = this.getValue().length();
            return this.getValue().substring(1, length - 1);
        }
    }
}

