/*
 * Decompiled with CFR 0.152.
 */
package com.github.mygreen.cellformatter.tokenizer;

import com.github.mygreen.cellformatter.lang.ArgUtils;
import com.github.mygreen.cellformatter.lang.Utils;
import com.github.mygreen.cellformatter.tokenizer.Token;
import java.util.ArrayList;
import java.util.List;

public class TokenStore {
    private List<Token> tokens = new ArrayList<Token>();

    public void add(Token token) {
        this.getTokens().add(token);
    }

    public List<Token> getTokens() {
        return this.tokens;
    }

    public List<TokenStore> split(Token.Symbol symbol) {
        ArgUtils.notNull(symbol, "symbol");
        ArrayList<TokenStore> list = new ArrayList<TokenStore>();
        TokenStore store = new TokenStore();
        list.add(store);
        for (Token token : this.tokens) {
            if (token.equals(symbol)) {
                store = new TokenStore();
                list.add(store);
                continue;
            }
            store.add(token);
        }
        return list;
    }

    public String getConcatenatedToken() {
        StringBuilder sb = new StringBuilder();
        for (Token token : this.tokens) {
            sb.append(token.getValue());
        }
        return sb.toString();
    }

    public boolean containsInFactor(String search) {
        return this.containsInFactor(search, false);
    }

    public boolean containsInFactorIgnoreCase(String search) {
        return this.containsInFactor(search, true);
    }

    public boolean containsInFactor(String search, boolean ignoreCase) {
        for (Token token : this.tokens) {
            if (!(token instanceof Token.Factor)) continue;
            Token.Factor factor = token.asFactor();
            if (!(ignoreCase ? Utils.containsIgnoreCase(factor.getValue(), search) : factor.getValue().contains(search))) continue;
            return true;
        }
        return false;
    }

    public boolean containsAnyInFactor(String[] searchChars) {
        return this.containsAnyInFactor(searchChars, false);
    }

    public boolean containsAnyInFactorIgnoreCase(String[] searchChars) {
        return this.containsAnyInFactor(searchChars, true);
    }

    private boolean containsAnyInFactor(String[] searchChars, boolean ignoreCase) {
        for (Token token : this.tokens) {
            Token.Factor factor;
            if (!(token instanceof Token.Factor) || !Utils.containsAny((factor = token.asFactor()).getValue(), searchChars, ignoreCase)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        int size = this.tokens.size();
        for (int i = 0; i < size; ++i) {
            Token token = this.tokens.get(i);
            sb.append(String.format("[%d]%s(%s)", i, token.getClass().getSimpleName(), token.getValue()));
            if (i >= size - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

