/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.mac;

import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.platform.mac.SystemB;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.common.AbstractGlobalMemory;
import oshi.jna.platform.mac.SystemB;
import oshi.util.platform.mac.SysctlUtil;

public class MacGlobalMemory
extends AbstractGlobalMemory {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MacGlobalMemory.class);
    private transient SystemB.XswUsage xswUsage = new SystemB.XswUsage();
    private long lastUpdateSwap = 0L;
    private transient SystemB.VMStatistics vmStats = new SystemB.VMStatistics();
    private long lastUpdateAvail = 0L;
    private long pageSize = 4096L;

    public MacGlobalMemory() {
        long memory = SysctlUtil.sysctl("hw.memsize", -1L);
        if (memory >= 0L) {
            this.memTotal = memory;
        }
        LongByReference pPageSize = new LongByReference();
        if (0 != SystemB.INSTANCE.host_page_size(SystemB.INSTANCE.mach_host_self(), pPageSize)) {
            LOG.error("Failed to get host page size. Error code: " + Native.getLastError());
            return;
        }
        this.pageSize = pPageSize.getValue();
    }

    @Override
    protected void updateMeminfo() {
        long now = System.currentTimeMillis();
        if (now - this.lastUpdateAvail > 100L) {
            if (0 != SystemB.INSTANCE.host_statistics(SystemB.INSTANCE.mach_host_self(), 2, (Structure)this.vmStats, new IntByReference(this.vmStats.size() / SystemB.INT_SIZE))) {
                LOG.error("Failed to get host VM info. Error code: " + Native.getLastError());
                return;
            }
            this.memAvailable = (long)(this.vmStats.free_count + this.vmStats.inactive_count) * this.pageSize;
            this.lastUpdateAvail = now;
        }
    }

    @Override
    protected void updateSwap() {
        long now = System.currentTimeMillis();
        if (now - this.lastUpdateSwap > 100L) {
            if (!SysctlUtil.sysctl("vm.swapusage", this.xswUsage)) {
                return;
            }
            this.swapUsed = this.xswUsage.xsu_used;
            this.swapTotal = this.xswUsage.xsu_total;
            this.lastUpdateSwap = now;
        }
    }
}

