/*
 * Decompiled with CFR 0.152.
 */
package oshi.hardware.platform.windows;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.SetupApi;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.NativeLongByReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import oshi.hardware.UsbDevice;
import oshi.hardware.common.AbstractUsbDevice;
import oshi.hardware.platform.mac.MacUsbDevice;
import oshi.jna.platform.windows.Cfgmgr32;
import oshi.util.ParseUtil;
import oshi.util.platform.windows.WmiUtil;

public class WindowsUsbDevice
extends AbstractUsbDevice {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(WindowsUsbDevice.class);
    private static final Pattern VENDOR_PRODUCT_ID = Pattern.compile(".*(?:VID|VEN)_(\\p{XDigit}{4})&(?:PID|DEV)_(\\p{XDigit}{4}).*");
    private static Map<String, String> nameMap = new HashMap<String, String>();
    private static Map<String, String> vendorMap = new HashMap<String, String>();
    private static Map<String, String> serialMap = new HashMap<String, String>();
    private static Map<String, List<String>> hubMap = new HashMap<String, List<String>>();

    public WindowsUsbDevice(String name, String vendor, String vendorId, String productId, String serialNumber, UsbDevice[] connectedDevices) {
        super(name, vendor, vendorId, productId, serialNumber, connectedDevices);
    }

    public static UsbDevice[] getUsbDevices(boolean tree) {
        UsbDevice[] devices = WindowsUsbDevice.getUsbDevices();
        if (tree) {
            return devices;
        }
        ArrayList<UsbDevice> deviceList = new ArrayList<UsbDevice>();
        for (UsbDevice device : devices) {
            WindowsUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
        return deviceList.toArray(new UsbDevice[deviceList.size()]);
    }

    private static void addDevicesToList(List<UsbDevice> deviceList, UsbDevice[] connectedDevices) {
        for (UsbDevice device : connectedDevices) {
            deviceList.add(new WindowsUsbDevice(device.getName(), device.getVendor(), device.getVendorId(), device.getProductId(), device.getSerialNumber(), new MacUsbDevice[0]));
            WindowsUsbDevice.addDevicesToList(deviceList, device.getConnectedDevices());
        }
    }

    private static UsbDevice[] getUsbDevices() {
        int i;
        nameMap.clear();
        vendorMap.clear();
        serialMap.clear();
        hubMap.clear();
        Map<String, List<String>> usbMap = WmiUtil.selectStringsFrom(null, "Win32_PnPEntity", "Name,Manufacturer,PnPDeviceID", null);
        for (i = 0; i < usbMap.get("Name").size(); ++i) {
            String pnpDeviceID = usbMap.get("PnPDeviceID").get(i);
            nameMap.put(pnpDeviceID, usbMap.get("Name").get(i));
            if (usbMap.get("Manufacturer").get(i).length() <= 0) continue;
            vendorMap.put(pnpDeviceID, usbMap.get("Manufacturer").get(i));
        }
        usbMap = WmiUtil.selectStringsFrom(null, "Win32_DiskDrive", "PNPDeviceID,SerialNumber", null);
        for (i = 0; i < usbMap.get("PNPDeviceID").size(); ++i) {
            serialMap.put(usbMap.get("PNPDeviceID").get(i), ParseUtil.hexStringToString(usbMap.get("PNPDeviceID").get(i)));
        }
        usbMap = WmiUtil.selectStringsFrom(null, "Win32_PhysicalMedia", "PNPDeviceID,SerialNumber", null);
        for (i = 0; i < usbMap.get("PNPDeviceID").size(); ++i) {
            serialMap.put(usbMap.get("PNPDeviceID").get(i), ParseUtil.hexStringToString(usbMap.get("PNPDeviceID").get(i)));
        }
        usbMap = WmiUtil.selectStringsFrom(null, "Win32_USBController", "PNPDeviceID", null);
        ArrayList<WindowsUsbDevice> controllerDevices = new ArrayList<WindowsUsbDevice>();
        for (String controllerDeviceId : usbMap.get("PNPDeviceID")) {
            WindowsUsbDevice.putChildrenInDeviceTree(controllerDeviceId, 0);
            controllerDevices.add(WindowsUsbDevice.getDeviceAndChildren(controllerDeviceId, "0000", "0000"));
        }
        return controllerDevices.toArray(new UsbDevice[controllerDevices.size()]);
    }

    private static void putChildrenInDeviceTree(String deviceId, int deviceInstance) {
        int devInst = deviceInstance;
        if (devInst == 0) {
            WinNT.HANDLE hinfoSet = SetupApi.INSTANCE.SetupDiGetClassDevs(null, null, null, 4);
            if (hinfoSet == WinNT.INVALID_HANDLE_VALUE) {
                LOG.error("Invalid handle value for {}. Error code: {}", (Object)deviceId, (Object)Native.getLastError());
                return;
            }
            SetupApi.SP_DEVINFO_DATA dinfo = new SetupApi.SP_DEVINFO_DATA();
            dinfo.cbSize = dinfo.size();
            int i = 0;
            while (SetupApi.INSTANCE.SetupDiEnumDeviceInfo(hinfoSet, i++, dinfo)) {
                if (!deviceId.equals(WindowsUsbDevice.getDeviceId(dinfo.DevInst))) continue;
                devInst = dinfo.DevInst;
                break;
            }
        }
        if (devInst == 0) {
            LOG.error("Unable to find a devnode handle for {}.", (Object)deviceId);
            return;
        }
        IntByReference child = new IntByReference();
        if (0 == Cfgmgr32.INSTANCE.CM_Get_Child(child, devInst, 0)) {
            ArrayList<String> childList = new ArrayList<String>();
            String childId = WindowsUsbDevice.getDeviceId(child.getValue());
            childList.add(childId);
            hubMap.put(deviceId, childList);
            WindowsUsbDevice.putChildrenInDeviceTree(childId, child.getValue());
            IntByReference sibling = new IntByReference();
            while (0 == Cfgmgr32.INSTANCE.CM_Get_Sibling(sibling, child.getValue(), 0)) {
                String siblingId = WindowsUsbDevice.getDeviceId(sibling.getValue());
                hubMap.get(deviceId).add(siblingId);
                WindowsUsbDevice.putChildrenInDeviceTree(siblingId, sibling.getValue());
                child = sibling;
            }
        }
    }

    private static String getDeviceId(int devInst) {
        NativeLongByReference ulLen = new NativeLongByReference();
        if (0 != Cfgmgr32.INSTANCE.CM_Get_Device_ID_Size(ulLen, devInst, 0)) {
            LOG.error("Couldn't get device string for device instance {}", (Object)devInst);
            return "";
        }
        int size = ulLen.getValue().intValue() + 1;
        char[] buffer = new char[size];
        if (0 != Cfgmgr32.INSTANCE.CM_Get_Device_ID(devInst, buffer, size, 0)) {
            LOG.error("Couldn't get device string for device instance {} with size {}", (Object)devInst, (Object)size);
            return "";
        }
        return new String(buffer).trim();
    }

    private static WindowsUsbDevice getDeviceAndChildren(String hubDeviceId, String vid, String pid) {
        String vendorId = vid;
        String productId = pid;
        Matcher m = VENDOR_PRODUCT_ID.matcher(hubDeviceId);
        if (m.matches()) {
            vendorId = m.group(1).toLowerCase();
            productId = m.group(2).toLowerCase();
        }
        List pnpDeviceIds = hubMap.getOrDefault(hubDeviceId, new ArrayList());
        ArrayList<WindowsUsbDevice> usbDevices = new ArrayList<WindowsUsbDevice>();
        for (String pnpDeviceId : pnpDeviceIds) {
            usbDevices.add(WindowsUsbDevice.getDeviceAndChildren(pnpDeviceId, vendorId, productId));
        }
        Collections.sort(usbDevices);
        return new WindowsUsbDevice(nameMap.getOrDefault(hubDeviceId, vendorId + ":" + productId), vendorMap.getOrDefault(hubDeviceId, ""), vendorId, productId, serialMap.getOrDefault(hubDeviceId, ""), usbDevices.toArray(new UsbDevice[usbDevices.size()]));
    }
}

