/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.commons.renditions;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.renditions.RenditionProvider;
import org.springframework.content.commons.renditions.RenditionService;
import org.springframework.util.MimeType;

public class RenditionServiceImpl
implements RenditionService {
    private List<RenditionProvider> providers = new ArrayList<RenditionProvider>();

    @Autowired(required=false)
    public RenditionServiceImpl(RenditionProvider ... providers) {
        for (RenditionProvider provider : providers) {
            this.providers.add(provider);
        }
    }

    @Override
    public boolean canConvert(String fromMimeType, String toMimeType) {
        for (RenditionProvider provider : this.providers) {
            if (!MimeType.valueOf((String)fromMimeType).includes(MimeType.valueOf((String)provider.consumes()))) continue;
            for (String produce : provider.produces()) {
                if (!MimeType.valueOf((String)toMimeType).includes(MimeType.valueOf((String)produce))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String[] conversions(String fromMimeType) {
        HashSet<String> conversions = new HashSet<String>();
        for (RenditionProvider provider : this.providers) {
            if (!provider.consumes().equals(fromMimeType)) continue;
            conversions.addAll(Arrays.asList(provider.produces()));
        }
        return conversions.toArray(new String[0]);
    }

    @Override
    public InputStream convert(String fromMimeType, InputStream fromInputSource, String toMimeType) {
        for (RenditionProvider provider : this.providers) {
            if (!MimeType.valueOf((String)fromMimeType).includes(MimeType.valueOf((String)provider.consumes()))) continue;
            for (String produce : provider.produces()) {
                if (!MimeType.valueOf((String)toMimeType).includes(MimeType.valueOf((String)produce))) continue;
                return provider.convert(fromInputSource, toMimeType);
            }
        }
        return null;
    }
}

