/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.commons.storeservice;

import internal.org.springframework.content.commons.store.factory.StoreFactory;
import internal.org.springframework.content.commons.storeservice.StoreInfoImpl;
import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.store.ContentStore;
import org.springframework.content.commons.storeservice.StoreFilter;
import org.springframework.content.commons.storeservice.StoreInfo;
import org.springframework.content.commons.storeservice.StoreResolver;
import org.springframework.content.commons.storeservice.Stores;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;

public class StoresImpl
implements Stores,
InitializingBean {
    private Set<StoreInfo> storeInfos = new HashSet<StoreInfo>();
    private Map<String, StoreResolver> resolvers = new HashMap<String, StoreResolver>();
    private ListableBeanFactory factory = null;

    public StoresImpl() {
    }

    @Autowired
    public StoresImpl(ListableBeanFactory factory) {
        this.factory = factory;
    }

    public void afterPropertiesSet() {
        String[] names;
        for (String name : names = this.factory.getBeanNamesForType(StoreFactory.class)) {
            StoreInfoImpl info;
            StoreFactory factory = (StoreFactory)this.factory.getBean(name, StoreFactory.class);
            if (org.springframework.content.commons.repository.ContentStore.class.isAssignableFrom(factory.getStoreInterface())) {
                info = new StoreInfoImpl(factory.getStoreInterface(), ((TypeInformation)ClassTypeInformation.from(factory.getStoreInterface()).getRequiredSuperTypeInformation(org.springframework.content.commons.repository.ContentStore.class).getTypeArguments().get(0)).getType(), new StoreSupplier(this.factory, this.beanNameFromFactoryBeanName(name)));
                this.storeInfos.add(info);
                continue;
            }
            if (ContentStore.class.isAssignableFrom(factory.getStoreInterface())) {
                info = new StoreInfoImpl(factory.getStoreInterface(), ((TypeInformation)ClassTypeInformation.from(factory.getStoreInterface()).getRequiredSuperTypeInformation(ContentStore.class).getTypeArguments().get(0)).getType(), new StoreSupplier(this.factory, this.beanNameFromFactoryBeanName(name)));
                this.storeInfos.add(info);
                continue;
            }
            info = new StoreInfoImpl(factory.getStoreInterface(), this.getDomainObjectClass(factory.getStoreInterface()), new StoreSupplier(this.factory, this.beanNameFromFactoryBeanName(name)));
            this.storeInfos.add(info);
        }
    }

    private String beanNameFromFactoryBeanName(String name) {
        return name.replaceFirst("&", "");
    }

    private Class<?> getDomainObjectClass(Class<?> contentStoreInterface) {
        Type[] genericInterfaces;
        for (Type genericInterface : genericInterfaces = contentStoreInterface.getGenericInterfaces()) {
            if (!(genericInterface instanceof ParameterizedType) || !((ParameterizedType)genericInterface).getRawType().equals(org.springframework.content.commons.repository.ContentStore.class)) continue;
            Type t = ((ParameterizedType)genericInterface).getActualTypeArguments()[0];
            return (Class)t;
        }
        return null;
    }

    @Override
    public void addStoreResolver(String name, StoreResolver resolver) {
        this.resolvers.put(name, resolver);
    }

    @Override
    public StoreInfo getStore(Class<?> storeType, StoreFilter filter) {
        Assert.notNull(storeType, (String)"storeType must not be null");
        Assert.notNull((Object)filter, (String)"filter must not be null");
        ArrayList<StoreInfo> candidates = new ArrayList<StoreInfo>();
        for (StoreInfo info : this.storeInfos) {
            if (info.getImplementation(storeType) == null || !filter.matches(info)) continue;
            candidates.add(info);
        }
        if (candidates.size() == 1) {
            return (StoreInfo)candidates.get(0);
        }
        if (candidates.size() > 1) {
            StoreResolver resolver = this.resolvers.get(filter.name());
            if (resolver == null) {
                throw new IllegalStateException("unable to resolve store.  Consider adding a StoreResolver");
            }
            return resolver.resolve(candidates.toArray(new StoreInfo[0]));
        }
        return null;
    }

    @Override
    public StoreInfo[] getStores(StoreFilter filter) {
        HashSet<StoreInfo> storeInfos = new HashSet<StoreInfo>();
        for (StoreInfo info : this.storeInfos) {
            if (!filter.matches(info)) continue;
            storeInfos.add(info);
        }
        return storeInfos.toArray(new StoreInfo[0]);
    }

    @Override
    public StoreInfo[] getStores(Class<?> storeType) {
        return this.getStores(storeType, MATCH_ALL);
    }

    @Override
    public StoreInfo[] getStores(Class<?> storeType, StoreFilter filter) {
        HashSet<StoreInfo> storeInfos = new HashSet<StoreInfo>();
        for (StoreInfo info : this.storeInfos) {
            if (info.getImplementation(storeType) == null || !filter.matches(info)) continue;
            storeInfos.add(info);
        }
        return storeInfos.toArray(new StoreInfo[0]);
    }

    public static class StoreSupplier
    implements Supplier<Store<Serializable>> {
        private final ListableBeanFactory factory;
        private final String storeFactoryBeanName;

        public StoreSupplier(ListableBeanFactory factory, String storeFactoryBeanName) {
            this.factory = factory;
            this.storeFactoryBeanName = storeFactoryBeanName;
        }

        @Override
        public Store<Serializable> get() {
            return (Store)this.factory.getBean(this.storeFactoryBeanName, Store.class);
        }
    }
}

