/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.commons.utils;

import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import java.lang.reflect.Field;
import java.util.UUID;
import org.springframework.data.mongodb.core.mapping.DBRef;

public final class ContentPropertyUtils {
    private static boolean IS_JPA_PRESENT = false;
    private static boolean IS_MONGO_PRESENT = false;

    private ContentPropertyUtils() {
    }

    public static boolean isPrimitiveContentPropertyClass(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.equals(UUID.class) || clazz.equals(String.class);
    }

    public static boolean isWrapperType(Class<?> type) {
        return Boolean.class.equals(type) || Byte.class.equals(type) || Character.class.equals(type) || Double.class.equals(type) || Float.class.equals(type) || Integer.class.equals(type) || Long.class.equals(type) || Short.class.equals(type);
    }

    public static boolean isRelationshipField(Field f) {
        if (IS_JPA_PRESENT && (f.getAnnotation(OneToOne.class) != null || f.getAnnotation(OneToMany.class) != null || f.getAnnotation(ManyToOne.class) != null || f.getAnnotation(ManyToMany.class) != null)) {
            return true;
        }
        return IS_MONGO_PRESENT && f.getAnnotation(DBRef.class) != null;
    }

    static {
        try {
            IS_JPA_PRESENT = Class.forName("jakarta.persistence.OneToOne") != null;
            IS_MONGO_PRESENT = Class.forName("org.springframework.data.mongodb.core.mapping.DBRef") != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

