/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.commons.utils;

import java.util.Collections;
import java.util.Set;
import org.springframework.content.commons.config.ContentPropertyInfo;
import org.springframework.content.commons.utils.PlacementService;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalConverter;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.lang.Nullable;

public class PlacementServiceImpl
extends DefaultConversionService
implements PlacementService {
    public static final String CONTENT_PROPERTY_INFO_GENERIC_PARAMETERS_MISSING_MESSAGE = "Unable to determine entity type <S> and content id type <SID> for " + ContentPropertyInfo.class.getName() + "; does the class parameterize those types?";

    public PlacementServiceImpl() {
        this.removeConvertible(Object.class, String.class);
    }

    @Nullable
    private ResolvableType[] getRequiredGenericParameters(Class<?> converterClass, Class<?> genericIfc) {
        ResolvableType resolvableType = ResolvableType.forClass(converterClass).as(genericIfc);
        ResolvableType[] generics = resolvableType.getGenerics();
        if (generics.length < 2) {
            return null;
        }
        Class sourceType = generics[0].resolve();
        Class targetType = generics[1].resolve();
        if (sourceType == null || targetType == null) {
            return null;
        }
        return generics;
    }

    public void addConverter(Converter<?, ?> converter) {
        ResolvableType[] generics = this.getRequiredGenericParameters(converter.getClass(), Converter.class);
        if (generics == null) {
            throw new IllegalArgumentException("Unable to determine source type <S> and target type <T> for your Converter [" + converter.getClass().getName() + "]; does the class parameterize those types?");
        }
        ResolvableType sourceType = generics[0];
        if (sourceType.resolve() == ContentPropertyInfo.class) {
            ResolvableType targetType = generics[1];
            ResolvableType[] sourceTypeGenerics = sourceType.getGenerics();
            if (sourceTypeGenerics.length != 2) {
                throw new IllegalArgumentException(CONTENT_PROPERTY_INFO_GENERIC_PARAMETERS_MISSING_MESSAGE);
            }
            Class entityClass = sourceTypeGenerics[0].resolve();
            Class contentIdClass = sourceTypeGenerics[1].resolve();
            if (entityClass == null || contentIdClass == null) {
                throw new IllegalArgumentException(CONTENT_PROPERTY_INFO_GENERIC_PARAMETERS_MISSING_MESSAGE);
            }
            this.addConverter((GenericConverter)new ContentPropertyInfoConverterAdapter(converter, sourceType, targetType, entityClass, contentIdClass));
        } else {
            super.addConverter(converter);
        }
    }

    public <S, T> void addConverter(Class<S> sourceType, Class<T> targetType, Converter<? super S, ? extends T> converter) {
        if (sourceType == ContentPropertyInfo.class) {
            throw new IllegalArgumentException("Adding of" + ContentPropertyInfo.class.getName() + " converter is not supported by this method; use addConverter(Converter<?, ?> converter) instead");
        }
        super.addConverter(sourceType, targetType, converter);
    }

    private final class ContentPropertyInfoConverterAdapter
    implements ConditionalGenericConverter {
        private final Converter<Object, Object> converter;
        private final GenericConverter.ConvertiblePair typeInfo;
        private final ResolvableType targetType;
        private final Class<?> entityClass;
        private final Class<?> contentIdClass;

        public ContentPropertyInfoConverterAdapter(Converter<?, ?> converter, ResolvableType sourceType, ResolvableType targetType, Class<?> entityClass, Class<?> contentIdClass) {
            this.converter = converter;
            this.typeInfo = new GenericConverter.ConvertiblePair(sourceType.toClass(), targetType.toClass());
            this.targetType = targetType;
            this.entityClass = entityClass;
            this.contentIdClass = contentIdClass;
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return Collections.singleton(this.typeInfo);
        }

        public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (this.typeInfo.getTargetType() != targetType.getObjectType()) {
                return false;
            }
            ResolvableType rt = targetType.getResolvableType();
            if (!(rt.getType() instanceof Class || rt.isAssignableFrom(this.targetType) || this.targetType.hasUnresolvableGenerics())) {
                return false;
            }
            ResolvableType[] generics = sourceType.getResolvableType().getGenerics();
            Class sourceEntityClass = generics[0].resolve();
            if (sourceEntityClass == null || !this.entityClass.isAssignableFrom(sourceEntityClass)) {
                return false;
            }
            Class sourceContentIdClass = generics[1].resolve();
            if (sourceContentIdClass == null || !this.contentIdClass.isAssignableFrom(sourceContentIdClass)) {
                return false;
            }
            return !(this.converter instanceof ConditionalConverter) || ((ConditionalConverter)this.converter).matches(sourceType, targetType);
        }

        @Nullable
        public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            if (source == null) {
                return PlacementServiceImpl.this.convertNullSource(sourceType, targetType);
            }
            return this.converter.convert(source);
        }

        public String toString() {
            return this.typeInfo + " : " + this.converter;
        }
    }
}

