/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.io;

import internal.org.springframework.content.rest.io.AssociatedStoreResource;
import internal.org.springframework.content.rest.io.RenderableResource;
import internal.org.springframework.content.rest.io.StoreResource;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.time.ZonedDateTime;
import org.springframework.content.commons.renditions.Renderable;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;
import org.springframework.web.servlet.resource.HttpResource;

public class RenderableResourceImpl
implements Resource,
HttpResource,
RenderableResource {
    private final Renderable renderer;
    private final StoreResource original;
    private final long lastModified;

    public RenderableResourceImpl(Renderable renderer, StoreResource original) {
        this.renderer = renderer;
        this.original = original;
        this.lastModified = ZonedDateTime.now().toInstant().toEpochMilli();
    }

    @Override
    public boolean isRenderableAs(MimeType mimeType) {
        if (this.original instanceof AssociatedStoreResource) {
            return this.renderer.hasRendition(((AssociatedStoreResource)this.original).getAssociation(), mimeType.toString());
        }
        return false;
    }

    @Override
    public InputStream renderAs(MimeType mimeType) {
        if (this.original instanceof AssociatedStoreResource) {
            return this.renderer.getRendition(((AssociatedStoreResource)this.original).getAssociation(), mimeType.toString());
        }
        return null;
    }

    public Object getETag() {
        return this.original.getETag();
    }

    public MediaType getMimeType() {
        return this.original.getMimeType();
    }

    public InputStream getInputStream() throws IOException {
        return this.original.getInputStream();
    }

    public long contentLength() throws IOException {
        return this.original.contentLength();
    }

    public long lastModified() throws IOException {
        return this.original.lastModified();
    }

    public boolean exists() {
        return this.original.exists();
    }

    public boolean isReadable() {
        return this.original.isReadable();
    }

    public boolean isOpen() {
        return this.original.isOpen();
    }

    public boolean isFile() {
        return this.original.isFile();
    }

    public URL getURL() throws IOException {
        return this.original.getURL();
    }

    public URI getURI() throws IOException {
        return this.original.getURI();
    }

    public File getFile() throws IOException {
        return this.original.getFile();
    }

    public ReadableByteChannel readableChannel() throws IOException {
        return this.original.readableChannel();
    }

    public Resource createRelative(String relativePath) throws IOException {
        return this.original.createRelative(relativePath);
    }

    @Nullable
    public String getFilename() {
        return this.original.getFilename();
    }

    public String getDescription() {
        return this.original.getDescription();
    }

    public HttpHeaders getResponseHeaders() {
        if (this.original instanceof HttpResource) {
            return ((HttpResource)this.original).getResponseHeaders();
        }
        return new HttpHeaders();
    }

    public OutputStream getOutputStream() throws IOException {
        return this.original.getOutputStream();
    }

    public void delete() throws IOException {
        this.original.delete();
    }
}

