/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.links;

import internal.org.springframework.content.rest.controllers.StoreRestController;
import internal.org.springframework.content.rest.io.StoreResource;
import internal.org.springframework.content.rest.mappingcontext.ContentPropertyToLinkrelMappingContext;
import internal.org.springframework.content.rest.mappingcontext.ContentPropertyToRequestMappingContext;
import internal.org.springframework.content.rest.utils.StoreUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.support.AopUtils;
import org.springframework.content.commons.mappingcontext.ContentProperty;
import org.springframework.content.commons.mappingcontext.MappingContext;
import org.springframework.content.commons.repository.AssociativeStore;
import org.springframework.content.commons.storeservice.StoreInfo;
import org.springframework.content.commons.storeservice.Stores;
import org.springframework.content.commons.utils.DomainObjectUtils;
import org.springframework.content.rest.StoreRestResource;
import org.springframework.content.rest.config.RestConfiguration;
import org.springframework.data.projection.TargetAware;
import org.springframework.data.rest.webmvc.BaseUri;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.hateoas.Affordance;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.RepresentationModelProcessor;
import org.springframework.hateoas.server.core.LinkBuilderSupport;
import org.springframework.http.HttpHeaders;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponents;

public class ContentLinksResourceProcessor
implements RepresentationModelProcessor<PersistentEntityResource> {
    private static final Log log = LogFactory.getLog(ContentLinksResourceProcessor.class);
    private static Method GET_CONTENT_METHOD = ReflectionUtils.findMethod(StoreRestController.class, (String)"getContent", (Class[])new Class[]{HttpServletRequest.class, HttpServletResponse.class, HttpHeaders.class, StoreResource.class});
    private final ContentPropertyToRequestMappingContext requestMappingContext;
    private final ContentPropertyToLinkrelMappingContext linkrelMappingContext;
    private Stores stores;
    private RestConfiguration config;
    private MappingContext mappingContext;

    public ContentLinksResourceProcessor(Stores stores, RestConfiguration config, MappingContext mappingContext, ContentPropertyToRequestMappingContext requestMappingContext, ContentPropertyToLinkrelMappingContext linkrelMappingContext) {
        this.stores = stores;
        this.config = config;
        this.mappingContext = mappingContext;
        this.requestMappingContext = requestMappingContext;
        this.linkrelMappingContext = linkrelMappingContext;
    }

    RestConfiguration getRestConfiguration() {
        return this.config;
    }

    public PersistentEntityResource process(PersistentEntityResource resource) {
        Object entityId;
        Object object = resource.getContent();
        if (object == null) {
            return resource;
        }
        if (this.isProjection(object)) {
            object = this.getProjectionTarget(object);
        }
        if ((entityId = DomainObjectUtils.getId((Object)object)) == null) {
            return resource;
        }
        Class persistentEntityType = resource.getPersistentEntity().getType();
        StoreInfo store = this.stores.getStore(AssociativeStore.class, Stores.withDomainClass((Class)persistentEntityType));
        if (store == null) {
            return resource;
        }
        Map contentProperties = this.mappingContext.getContentPropertyMap(persistentEntityType);
        if (contentProperties.size() == 1 && this.config.shortcutLinks() && !this.config.fullyQualifiedLinks()) {
            this.originalLink(this.config.getBaseUri(), store, entityId).ifPresent(l -> this.addLink(resource, (Link)l));
            this.addLink(resource, this.shortcutLink(this.config.getBaseUri(), store, entityId, StringUtils.uncapitalize((String)StoreUtils.getSimpleName(store))));
        } else {
            for (Map.Entry<String, ContentProperty> entry : contentProperties.entrySet()) {
                resource.add(this.fullyQualifiedLink(this.config.getBaseUri(), store, entityId, entry));
            }
        }
        return resource;
    }

    private void addLink(PersistentEntityResource resource, Link l) {
        if (resource.hasLink(l.getRel())) {
            for (Link existingLink : resource.getLinks(l.getRel())) {
                if (!existingLink.getHref().equals(l.getHref())) continue;
                return;
            }
        }
        resource.add(l);
    }

    private String propertyLinkRel(StoreInfo storeInfo, Map.Entry<String, ContentProperty> contentProperty) {
        Class storeIface;
        StoreRestResource exportSpec;
        String uriPath = contentProperty.getKey();
        Map<String, String> linkrelMappings = this.linkrelMappingContext.getMappings(storeInfo.getDomainObjectClass());
        Object linkrel = linkrelMappings.get(uriPath);
        if (linkrel == null || !StringUtils.hasLength((String)linkrel)) {
            linkrel = uriPath;
        }
        if ((exportSpec = (storeIface = storeInfo.getInterface()).getAnnotation(StoreRestResource.class)) != null && !StringUtils.isEmpty((Object)exportSpec.linkRel())) {
            linkrel = exportSpec.linkRel() + "/" + (String)linkrel;
        }
        return linkrel;
    }

    private String entityRel(StoreInfo storeInfo, String defaultLinkRel) {
        String entityLinkRel = defaultLinkRel;
        Class storeIface = storeInfo.getInterface();
        StoreRestResource exportSpec = storeIface.getAnnotation(StoreRestResource.class);
        if (exportSpec != null && !StringUtils.isEmpty((Object)exportSpec.linkRel())) {
            entityLinkRel = exportSpec.linkRel();
        }
        return entityLinkRel;
    }

    private Optional<Link> originalLink(URI baseUri, StoreInfo store, Object id) {
        if (id == null) {
            return Optional.empty();
        }
        return Optional.of(this.shortcutLink(baseUri, store, id, StoreUtils.storePath(store)));
    }

    private Link shortcutLink(URI baseUri, StoreInfo store, Object id, String defaultLinkRel) {
        StoreLinkBuilder builder = null;
        builder = StoreLinkBuilder.linkTo(new BaseUri(baseUri), store);
        builder = builder.slash(id);
        return builder.withRel(this.entityRel(store, defaultLinkRel));
    }

    private Link fullyQualifiedLink(URI baseUri, StoreInfo store, Object id, Map.Entry<String, ContentProperty> contentPropertyEntry) {
        Assert.notNull((Object)id, (String)"id must not be null");
        StoreLinkBuilder builder = StoreLinkBuilder.linkTo(new BaseUri(baseUri), store);
        builder = builder.slash(id);
        String requestMapping = this.requestMappingContext.getMappings(store.getDomainObjectClass()).get(contentPropertyEntry.getKey());
        builder = StringUtils.hasText((String)requestMapping) ? builder.slash(requestMapping) : builder.slash(contentPropertyEntry.getKey());
        return builder.withRel(this.propertyLinkRel(store, contentPropertyEntry));
    }

    private Object getProjectionTarget(Object object) {
        return ((TargetAware)object).getTarget();
    }

    private boolean isProjection(Object object) {
        return AopUtils.isAopProxy((Object)object);
    }

    static {
        Assert.notNull((Object)GET_CONTENT_METHOD, (String)"Unable to find StoreRestController.getContent method");
    }

    public static class StoreLinkBuilder
    extends LinkBuilderSupport<StoreLinkBuilder> {
        public StoreLinkBuilder(BaseUri baseUri, StoreInfo store) {
            super(baseUri.getUriComponentsBuilder().path(StoreLinkBuilder.storePath(store)).build());
        }

        protected StoreLinkBuilder getThis() {
            return this;
        }

        protected StoreLinkBuilder createNewInstance(UriComponents components, List<Affordance> affordances) {
            return new StoreLinkBuilder(new BaseUri(components.toUriString()), null);
        }

        public static StoreLinkBuilder linkTo(BaseUri baseUri, StoreInfo store) {
            return new StoreLinkBuilder(baseUri, store);
        }

        private static String storePath(StoreInfo store) {
            if (store == null) {
                return "";
            }
            return String.format("/%s", StoreUtils.storePath(store));
        }
    }
}

