/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.content.rest.config;

import internal.org.springframework.content.rest.utils.StoreUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.http.CacheControl;
import org.springframework.util.AntPathMatcher;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.util.UrlPathHelper;

public class StoreCacheControlInterceptor
implements HandlerInterceptor {
    private Map<String, CacheControl> cacheControlMap = new HashMap<String, CacheControl>();
    private List<CacheControlRule> cacheControlRules = new ArrayList<CacheControlRule>();
    private URI baseUri;

    public StoreCacheControlConfigurer configurer() {
        return new StoreCacheControlConfigurer(this);
    }

    public void addCacheControl(String mapping, CacheControl cacheControl) {
        this.cacheControlMap.put(mapping, cacheControl);
    }

    public void addCacheControlRule(CacheControlRule cacheControlRule) {
        this.cacheControlRules.add(cacheControlRule);
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (!"GET".equals(request.getMethod())) {
            return true;
        }
        UrlPathHelper pathHelper = UrlPathHelper.defaultInstance;
        String lookupPath = pathHelper.getLookupPathForRequest(request);
        String storeLookupPath = StoreUtils.storeLookupPath(lookupPath, this.baseUri);
        CacheControl cacheControl = this.cacheControlMap.get(storeLookupPath);
        for (CacheControlRule rule : this.cacheControlRules) {
            if (!rule.match(storeLookupPath)) continue;
            response.addHeader("Cache-Control", rule.getCacheControl().getHeaderValue());
        }
        return true;
    }

    public void setBaseUri(URI baseUri) {
        this.baseUri = baseUri;
    }

    public static class StoreCacheControlConfigurer {
        private final StoreCacheControlInterceptor interceptor;

        public StoreCacheControlConfigurer(StoreCacheControlInterceptor interceptor) {
            this.interceptor = interceptor;
        }

        public StoreCacheControlConfigurer antMatcher(String pattern, CacheControl cacheControl) {
            this.interceptor.addCacheControlRule(new CacheControlRule(pattern, cacheControl));
            return this;
        }
    }

    static class CacheControlRule {
        private static AntPathMatcher matcher = new AntPathMatcher();
        private String pattern;
        private CacheControl cacheControl;

        public CacheControlRule(String pattern, CacheControl control) {
            this.pattern = pattern;
            this.cacheControl = control;
        }

        public boolean match(String path) {
            return matcher.match(this.pattern, path);
        }

        @Generated
        public String getPattern() {
            return this.pattern;
        }

        @Generated
        public CacheControl getCacheControl() {
            return this.cacheControl;
        }
    }
}

