/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.extensions.entitycontent;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.MultiValueMap;

public class RepositoryEntityMultipartHttpMessageConverter
implements HttpMessageConverter<Object> {
    private HttpMessageConverter converter = null;

    public RepositoryEntityMultipartHttpMessageConverter(List<HttpMessageConverter<?>> messageConverters) {
        for (HttpMessageConverter<?> converter : messageConverters) {
            if (!converter.canRead(RepresentationModel.class, MediaType.APPLICATION_JSON)) continue;
            this.converter = converter;
            break;
        }
        if (this.converter == null) {
            throw new IllegalStateException("unable to resolve persistent entity resource message converter");
        }
    }

    public boolean canRead(Class clazz, MediaType mediaType) {
        return PersistentEntityResource.class.equals((Object)clazz) && mediaType != null && mediaType.includes(MediaType.MULTIPART_FORM_DATA);
    }

    public boolean canWrite(Class clazz, MediaType mediaType) {
        return false;
    }

    public List<MediaType> getSupportedMediaTypes() {
        return Collections.singletonList(MediaType.MULTIPART_FORM_DATA);
    }

    public List<MediaType> getSupportedMediaTypes(Class clazz) {
        return super.getSupportedMediaTypes(clazz);
    }

    public Object read(Class clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        if (!(inputMessage instanceof ServletServerHttpRequest)) {
            return null;
        }
        BeanWrapperImpl wrapper = new BeanWrapperImpl(clazz);
        final HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        Enumeration paramNames = ((ServletServerHttpRequest)inputMessage).getServletRequest().getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            PropertyDescriptor descriptor = null;
            try {
                descriptor = wrapper.getPropertyDescriptor(paramName);
            }
            catch (InvalidPropertyException ipe) {
                descriptor = this.findJsonProperty(clazz, paramName, (BeanWrapper)wrapper);
            }
            if (descriptor == null) continue;
            if (descriptor.getPropertyType().isArray() || Collection.class.isAssignableFrom(descriptor.getPropertyType())) {
                paramsMap.put(paramName, ((ServletServerHttpRequest)inputMessage).getServletRequest().getParameterValues(paramName));
                continue;
            }
            paramsMap.put(paramName, ((ServletServerHttpRequest)inputMessage).getServletRequest().getParameter(paramName));
        }
        final HttpHeaders headers = new HttpHeaders((MultiValueMap)inputMessage.getHeaders());
        headers.setContentType(MediaType.APPLICATION_JSON);
        return this.converter.read(clazz, new HttpInputMessage(){

            public InputStream getBody() throws IOException {
                ObjectMapper mapper = new ObjectMapper();
                String convertedFormData = mapper.writeValueAsString((Object)paramsMap);
                return new ByteArrayInputStream(convertedFormData.getBytes());
            }

            public HttpHeaders getHeaders() {
                return headers;
            }
        });
    }

    public void write(Object o, MediaType contentType, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        throw new UnsupportedEncodingException();
    }

    private PropertyDescriptor findJsonProperty(Class<?> clazz, String propertyName, BeanWrapper beanWrapper) {
        for (PropertyDescriptor propertyDescriptor : beanWrapper.getPropertyDescriptors()) {
            JsonProperty jsonPropertyAnnotation;
            String jsonPropertyName;
            String name = propertyDescriptor.getName();
            Field field = RepositoryEntityMultipartHttpMessageConverter.findField(clazz, name);
            if (field == null || !field.isAnnotationPresent(JsonProperty.class) || !(jsonPropertyName = (jsonPropertyAnnotation = field.getAnnotation(JsonProperty.class)).value()).equals(propertyName)) continue;
            return propertyDescriptor;
        }
        return null;
    }

    private static Field findField(Class<?> clazz, String propertyName) {
        try {
            return clazz.getDeclaredField(propertyName);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }
}

