/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.contentservice;

import internal.org.springframework.content.rest.contentservice.ContentService;
import internal.org.springframework.content.rest.contentservice.ContentStoreContentService;
import internal.org.springframework.content.rest.controllers.MethodNotAllowedException;
import internal.org.springframework.content.rest.io.AssociatedStoreResource;
import internal.org.springframework.content.rest.io.RenderedResource;
import internal.org.springframework.content.rest.io.StoreResource;
import internal.org.springframework.content.rest.mappings.StoreByteRangeHttpRequestHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.content.commons.io.RangeableResource;
import org.springframework.content.commons.mappingcontext.ContentProperty;
import org.springframework.content.commons.property.PropertyPath;
import org.springframework.content.commons.repository.AssociativeStore;
import org.springframework.content.commons.repository.ContentStore;
import org.springframework.content.commons.storeservice.StoreInfo;
import org.springframework.content.rest.RestResource;
import org.springframework.content.rest.config.RestConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.WritableResource;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.util.MimeType;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.server.ResponseStatusException;

public class AssociativeStoreContentService
implements ContentService {
    private static final Logger logger = LoggerFactory.getLogger(AssociativeStoreContentService.class);
    private static final Map<Class<?>, StoreExportedMethodsMap> storeExportedMethods = new HashMap();
    private final RestConfiguration config;
    private final StoreInfo store;
    private final RepositoryInvoker repoInvoker;
    private final Object domainObj;
    private final Object embeddedProperty;
    private final StoreByteRangeHttpRequestHandler byteRangeRestRequestHandler;

    public AssociativeStoreContentService(RestConfiguration config, StoreInfo store, RepositoryInvoker repoInvoker, Object domainObj, StoreByteRangeHttpRequestHandler byteRangeRestRequestHandler) {
        this.config = config;
        this.store = store;
        this.repoInvoker = repoInvoker;
        this.domainObj = domainObj;
        this.embeddedProperty = null;
        this.byteRangeRestRequestHandler = byteRangeRestRequestHandler;
    }

    public AssociativeStoreContentService(RestConfiguration config, StoreInfo store, RepositoryInvoker repoInvoker, Object domainObj, StoreByteRangeHttpRequestHandler byteRangeRestRequestHandler, ApplicationContext context) {
        this.config = config;
        this.store = store;
        this.repoInvoker = repoInvoker;
        this.domainObj = domainObj;
        this.embeddedProperty = null;
        this.byteRangeRestRequestHandler = byteRangeRestRequestHandler;
    }

    public AssociativeStoreContentService(RestConfiguration config, StoreInfo store, RepositoryInvoker repoInvoker, Object domainObj, Object embeddedProperty, StoreByteRangeHttpRequestHandler byteRangeRestRequestHandler) {
        this.config = config;
        this.store = store;
        this.repoInvoker = repoInvoker;
        this.domainObj = domainObj;
        this.embeddedProperty = embeddedProperty;
        this.byteRangeRestRequestHandler = byteRangeRestRequestHandler;
    }

    @Override
    public void getContent(HttpServletRequest request, HttpServletResponse response, HttpHeaders headers, Resource resource, MediaType resourceType) throws ResponseStatusException, MethodNotAllowedException {
        block11: {
            Method[] methodsToUse = AssociativeStoreContentService.getExportedMethodsFor(((StoreResource)resource).getStoreInfo().getInterface()).getResourceMethods();
            if (methodsToUse.length > 1) {
                throw new IllegalStateException("Too many getResource methods");
            }
            if (methodsToUse.length == 0) {
                throw new MethodNotAllowedException();
            }
            try {
                MediaType producedResourceType = null;
                List acceptedMimeTypes = headers.getAccept();
                if (acceptedMimeTypes.size() > 0) {
                    MediaType.sortBySpecificityAndQuality((List)acceptedMimeTypes);
                    for (MediaType acceptedMimeType : acceptedMimeTypes) {
                        if (acceptedMimeType.includes(resourceType) && this.matchParameters(acceptedMimeType, resourceType)) {
                            producedResourceType = resourceType;
                            break;
                        }
                        if (!((StoreResource)resource).isRenderableAs((MimeType)acceptedMimeType)) continue;
                        resource = new RenderedResource(((StoreResource)resource).renderAs((MimeType)acceptedMimeType), (Resource)resource);
                        producedResourceType = acceptedMimeType;
                        break;
                    }
                    if (producedResourceType == null) {
                        response.setStatus(HttpStatus.NOT_FOUND.value());
                        return;
                    }
                }
                if (resource instanceof RangeableResource) {
                    this.configureResourceForByteRangeRequest((RangeableResource)resource, headers);
                }
                request.setAttribute("SPRING_CONTENT_RESOURCE", resource);
                request.setAttribute("SPRING_CONTENT_CONTENTTYPE", producedResourceType);
            }
            catch (Exception e) {
                logger.error("Unable to retrieve content", (Throwable)e);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, String.format("Failed to handle request for %s", resource.getDescription()), (Throwable)e);
            }
            try {
                this.byteRangeRestRequestHandler.handleRequest(request, response);
            }
            catch (Exception e) {
                if (ContentStoreContentService.isClientAbortException(e)) break block11;
                logger.error("Unable to handle request", (Throwable)e);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, String.format("Failed to handle request for %s", resource.getDescription()), (Throwable)e);
            }
        }
    }

    @Override
    public void setContent(HttpServletRequest request, HttpServletResponse response, HttpHeaders headers, Resource source, MediaType sourceMimeType, Resource target) throws IOException, MethodNotAllowedException {
        Method[] methodsToUse;
        AssociatedStoreResource storeResource = (AssociatedStoreResource)target;
        ContentProperty property = storeResource.getContentProperty();
        Object updateObject = storeResource.getAssociation();
        property.setMimeType(updateObject, (Object)sourceMimeType.toString());
        String originalFilename = source.getFilename();
        if (source.getFilename() != null && StringUtils.hasText((String)originalFilename)) {
            property.setOriginalFileName(updateObject, (Object)source.getFilename());
        }
        if ((methodsToUse = AssociativeStoreContentService.getExportedMethodsFor(((StoreResource)target).getStoreInfo().getInterface()).getResourceMethods()).length == 0) {
            throw new MethodNotAllowedException();
        }
        Method methodToUse = methodsToUse[0];
        long len = IOUtils.copyLarge((InputStream)source.getInputStream(), (OutputStream)((WritableResource)target).getOutputStream());
        property.setContentLength(updateObject, (Object)len);
        this.repoInvoker.invokeSave(updateObject);
    }

    @Override
    public void unsetContent(Resource resource) throws MethodNotAllowedException {
        AssociatedStoreResource storeResource = (AssociatedStoreResource)resource;
        ContentProperty property = storeResource.getContentProperty();
        Method[] methodsToUse = AssociativeStoreContentService.getExportedMethodsFor(((StoreResource)resource).getStoreInfo().getInterface()).getResourceMethods();
        if (methodsToUse.length == 0) {
            throw new MethodNotAllowedException();
        }
        if (methodsToUse.length > 1) {
            throw new IllegalStateException("Too many unsetContent methods");
        }
        Object updateObject = storeResource.getAssociation();
        AssociativeStore targetObj = (AssociativeStore)storeResource.getStoreInfo().getImplementation(AssociativeStore.class);
        try {
            storeResource.delete();
            targetObj.unassociate(updateObject, PropertyPath.from((String)property.getContentPropertyPath()));
            property.setContentLength(updateObject, (Object)0);
            property.setMimeType(updateObject, null);
            property.setOriginalFileName(updateObject, null);
            this.repoInvoker.invokeSave(updateObject);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean matchParameters(MediaType acceptedMediaType, MediaType producableMediaType) {
        for (String name : producableMediaType.getParameters().keySet()) {
            String s1 = producableMediaType.getParameter(name);
            String s2 = acceptedMediaType.getParameter(name);
            if (!StringUtils.hasText((String)s1) || !StringUtils.hasText((String)s2) || s1.equalsIgnoreCase(s2)) continue;
            return false;
        }
        return true;
    }

    public static StoreExportedMethodsMap getExportedMethodsFor(Class<?> storeInterfaceClass) {
        StoreExportedMethodsMap exportMap = storeExportedMethods.get(storeInterfaceClass);
        if (exportMap == null) {
            storeExportedMethods.put(storeInterfaceClass, new StoreExportedMethodsMap(storeInterfaceClass));
            exportMap = storeExportedMethods.get(storeInterfaceClass);
        }
        return exportMap;
    }

    private void configureResourceForByteRangeRequest(RangeableResource resource, HttpHeaders headers) {
        if (headers.containsKey((Object)"Range")) {
            resource.setRange(headers.getFirst("Range"));
        }
    }

    public static class StoreExportedMethodsMap {
        private static Method[] GETRESOURCE_METHODS = null;
        private static Method[] SETCONTENT_METHODS = null;
        private static Method[] UNSETCONTENT_METHODS = null;
        private static Method[] GETCONTENT_METHODS = null;
        private Class<?> storeInterface;
        private Method[] getResourceMethods;
        private Method[] getContentMethods;
        private Method[] setContentMethods;
        private Method[] unsetContentMethods;

        public StoreExportedMethodsMap(Class<?> storeInterface) {
            this.storeInterface = storeInterface;
            this.getResourceMethods = this.calculateExports(GETRESOURCE_METHODS);
            this.getContentMethods = this.calculateExports(GETCONTENT_METHODS);
            this.setContentMethods = this.calculateExports(SETCONTENT_METHODS);
            this.unsetContentMethods = this.calculateExports(UNSETCONTENT_METHODS);
        }

        public Method[] getResourceMethods() {
            return this.getResourceMethods;
        }

        public Method[] getContentMethods() {
            return this.getContentMethods;
        }

        public Method[] setContentMethods() {
            return this.setContentMethods;
        }

        public Method[] unsetContentMethods() {
            return this.unsetContentMethods;
        }

        private Method[] calculateExports(Method[] storeMethods) {
            ArrayList<Method> exportedMethods = new ArrayList<Method>();
            exportedMethods.addAll(Arrays.asList(storeMethods));
            ArrayList<Method> unexportedMethods = new ArrayList<Method>();
            for (Method m : exportedMethods) {
                for (Method dm : this.storeInterface.getDeclaredMethods()) {
                    RestResource r;
                    if (dm.isBridge() || !dm.getName().equals(m.getName()) || !this.argsMatch(dm, m) || (r = dm.getAnnotation(RestResource.class)) == null || r.exported()) continue;
                    unexportedMethods.add(m);
                }
            }
            for (Method unexportedMethod : unexportedMethods) {
                exportedMethods.remove(unexportedMethod);
            }
            return exportedMethods.toArray(new Method[0]);
        }

        private boolean argsMatch(Method dm, Method m) {
            for (int i = 0; i < m.getParameterTypes().length; ++i) {
                if (m.getParameterTypes()[i].isAssignableFrom(dm.getParameterTypes()[i])) continue;
                return false;
            }
            return true;
        }

        static {
            GETRESOURCE_METHODS = new Method[]{ReflectionUtils.findMethod(AssociativeStore.class, (String)"getResource", (Class[])new Class[]{Object.class, PropertyPath.class})};
            SETCONTENT_METHODS = new Method[]{ReflectionUtils.findMethod(ContentStore.class, (String)"setContent", (Class[])new Class[]{Object.class, InputStream.class}), ReflectionUtils.findMethod(ContentStore.class, (String)"setContent", (Class[])new Class[]{Object.class, Resource.class})};
            UNSETCONTENT_METHODS = new Method[]{ReflectionUtils.findMethod(ContentStore.class, (String)"unsetContent", (Class[])new Class[]{Object.class})};
            GETCONTENT_METHODS = new Method[]{ReflectionUtils.findMethod(ContentStore.class, (String)"getContent", (Class[])new Class[]{Object.class})};
        }
    }
}

