/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.contentservice;

import internal.org.springframework.content.rest.contentservice.AssociativeStoreContentService;
import internal.org.springframework.content.rest.contentservice.ContentService;
import internal.org.springframework.content.rest.contentservice.ContentStoreContentService;
import internal.org.springframework.content.rest.contentservice.StoreContentService;
import internal.org.springframework.content.rest.io.AssociatedStoreResource;
import internal.org.springframework.content.rest.io.StoreResource;
import internal.org.springframework.content.rest.mappingcontext.ContentPropertyToExportedContext;
import internal.org.springframework.content.rest.mappings.StoreByteRangeHttpRequestHandler;
import org.springframework.content.commons.mappingcontext.MappingContext;
import org.springframework.content.commons.repository.AssociativeStore;
import org.springframework.content.commons.store.ContentStore;
import org.springframework.content.commons.storeservice.Stores;
import org.springframework.content.rest.config.RestConfiguration;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvokerFactory;

public class ContentServiceFactory {
    private final RestConfiguration config;
    private final Repositories repositories;
    private final RepositoryInvokerFactory repoInvokerFactory;
    private final Stores stores;
    private MappingContext mappingContext;
    private final ContentPropertyToExportedContext exportContext;
    private final StoreByteRangeHttpRequestHandler byteRangeRestRequestHandler;

    public ContentServiceFactory(RestConfiguration config, Repositories repositories, RepositoryInvokerFactory repoInvokerFactory, Stores stores, MappingContext mappingContext, ContentPropertyToExportedContext exportContext, StoreByteRangeHttpRequestHandler byteRangeRestRequestHandler) {
        this.config = config;
        this.repositories = repositories;
        this.repoInvokerFactory = repoInvokerFactory;
        this.stores = stores;
        this.mappingContext = mappingContext;
        this.exportContext = exportContext;
        this.byteRangeRestRequestHandler = byteRangeRestRequestHandler;
    }

    public ContentService getContentService(StoreResource resource) {
        if (org.springframework.content.commons.repository.ContentStore.class.isAssignableFrom(resource.getStoreInfo().getInterface()) || ContentStore.class.isAssignableFrom(resource.getStoreInfo().getInterface())) {
            Object entity = ((AssociatedStoreResource)resource).getAssociation();
            return new ContentStoreContentService(this.config, null, this.repoInvokerFactory.getInvokerFor(entity.getClass()), this.mappingContext, this.exportContext, this.byteRangeRestRequestHandler);
        }
        if (AssociativeStore.class.isAssignableFrom(resource.getStoreInfo().getInterface()) || org.springframework.content.commons.store.AssociativeStore.class.isAssignableFrom(resource.getStoreInfo().getInterface())) {
            Object entity = ((AssociatedStoreResource)resource).getAssociation();
            return new AssociativeStoreContentService(this.config, null, this.repoInvokerFactory.getInvokerFor(entity.getClass()), entity, this.byteRangeRestRequestHandler);
        }
        return new StoreContentService(this.byteRangeRestRequestHandler);
    }
}

