/*
 * Decompiled with CFR 0.152.
 */
package internal.org.springframework.content.rest.controllers.resolvers;

import internal.org.springframework.content.rest.controllers.ResourceNotFoundException;
import internal.org.springframework.content.rest.controllers.resolvers.EntityResolution;
import internal.org.springframework.content.rest.controllers.resolvers.EntityResolver;
import internal.org.springframework.content.rest.utils.StoreUtils;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import org.springframework.content.commons.mappingcontext.MappingContext;
import org.springframework.content.commons.property.PropertyPath;
import org.springframework.content.commons.repository.Store;
import org.springframework.content.commons.storeservice.StoreInfo;
import org.springframework.content.commons.storeservice.Stores;
import org.springframework.data.history.Revision;
import org.springframework.data.repository.history.RevisionRepository;
import org.springframework.data.repository.support.Repositories;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class RevisionEntityResolver
implements EntityResolver {
    private Repositories repositories;
    private Stores stores;
    private String mapping;
    private MappingContext mappingContext;

    public RevisionEntityResolver(Repositories repositories, Stores stores, String mapping, MappingContext mappingContext) {
        this.repositories = repositories;
        this.stores = stores;
        this.mapping = mapping;
        this.mappingContext = mappingContext;
    }

    @Override
    public String getMapping() {
        return this.mapping;
    }

    @Override
    public EntityResolution resolve(String pathInfo) {
        AntPathMatcher matcher = new AntPathMatcher();
        Map variables = matcher.extractUriTemplateVariables(this.mapping, pathInfo);
        String repository = (String)variables.get("repository");
        String id = (String)variables.get("id");
        String revisionId = (String)variables.get("revisionId");
        Method FIND_REVISION_METHOD = ReflectionUtils.findMethod(RevisionRepository.class, (String)"findRevision", (Class[])new Class[]{Object.class, Number.class});
        Assert.notNull((Object)FIND_REVISION_METHOD, (String)"findRevision method cannot be null");
        String[] pathSegments = pathInfo.split("/");
        String store = pathSegments[1];
        StoreInfo info = this.stores.getStore(Store.class, StoreUtils.withStorePath(store));
        if (info == null) {
            throw new IllegalArgumentException(String.format("Store for path %s not found", store));
        }
        Optional repo = this.repositories.getRepositoryFor(info.getDomainObjectClass());
        repo.orElseThrow(() -> new IllegalStateException(String.format("Unable to find repository '%s'", repository)));
        Optional revision = (Optional)ReflectionUtils.invokeMethod((Method)FIND_REVISION_METHOD, repo.get(), (Object[])new Object[]{Long.parseLong(id), Integer.parseInt(revisionId)});
        Object domainObj = null;
        if (!revision.isPresent()) {
            throw new ResourceNotFoundException();
        }
        domainObj = ((Revision)revision.get()).getEntity();
        String propertyPath = matcher.extractPathWithinPattern(this.mapping, pathInfo);
        if (propertyPath == null) {
            propertyPath = "";
        }
        return new EntityResolution(domainObj, PropertyPath.from((String)propertyPath));
    }

    @Override
    public boolean hasPropertyFor(String pathInfo) {
        AntPathMatcher matcher = new AntPathMatcher();
        Map variables = matcher.extractUriTemplateVariables(this.mapping, pathInfo);
        String[] pathSegments = pathInfo.split("/");
        String store = pathSegments[1];
        StoreInfo info = this.stores.getStore(Store.class, StoreUtils.withStorePath(store));
        if (info == null) {
            throw new IllegalArgumentException(String.format("Store for path %s not found", store));
        }
        String propertyPath = matcher.extractPathWithinPattern(this.mapping, pathInfo);
        if (propertyPath == null) {
            propertyPath = "";
        }
        return this.mappingContext.getContentProperty(info.getDomainObjectClass(), propertyPath) != null;
    }
}

